# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # Filters limit replication to a subset of blobs within the storage
    # account. A logical OR is performed on values in the filter. If multiple
    # filters are defined, a logical AND is performed on all filters.
    #
    class ObjectReplicationPolicyFilter

      include MsRestAzure

      # @return [Array<String>] Optional. Filters the results to replicate only
      # blobs whose names begin with the specified prefix.
      attr_accessor :prefix_match

      # @return [String] Blobs created after the time will be replicated to the
      # destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'.
      # Example: 2020-02-19T16:05:00Z
      attr_accessor :min_creation_time


      #
      # Mapper for ObjectReplicationPolicyFilter class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ObjectReplicationPolicyFilter',
          type: {
            name: 'Composite',
            class_name: 'ObjectReplicationPolicyFilter',
            model_properties: {
              prefix_match: {
                client_side_validation: true,
                required: false,
                serialized_name: 'prefixMatch',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              min_creation_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'minCreationTime',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
