require_relative "../ridley_compat"

module Berkshelf
  module APIClient
    require_relative "errors"

    class ChefServerConnection
      def initialize(**args)
        @client = Berkshelf::RidleyCompat.new(**args)
        @url = args[:server_url]
      end

      def universe
        response = @client.get("universe")

        [].tap do |cookbooks|
          response.each do |name, versions|
            versions.each do |version, attributes|
              attributes[:location_path] = @url
              cookbooks << RemoteCookbook.new(name, version, attributes)
            end
          end
        end
      rescue Ridley::Errors::HTTPNotFound
        raise ServiceNotFound, "service not found at: #{@url}"
      end
    end
  end
end
