# frozen_string_literal: true

module DropletKit
  class Droplet < BaseModel
    %i[id name memory vcpus disk locked created_at
       status backup_ids snapshot_ids action_ids features
       region image networks kernel size_slug tags
       volume_ids].each do |key|
      attribute(key)
    end

    # Used for creates
    attribute :names
    attribute :volumes
    attribute :ssh_keys
    attribute :backups
    attribute :monitoring
    attribute :with_droplet_agent
    attribute :size
    attribute :ipv6
    attribute :user_data
    attribute :private_networking
    attribute :vpc_uuid

    def public_ip
      network = network_for(:v4, 'public')
      network&.ip_address
    end

    def private_ip
      network = network_for(:v4, 'private')
      network&.ip_address
    end

    private

    def network_for(type, publicity)
      networks = case type
                 when :v4 then self.networks.v4
                 when :v6 then self.networks.v6
                 end

      networks.find do |network|
        network.type == publicity
      end
    end
  end
end
