# Author: Jesse Campbell
#
# Permission to use, copy, modify, and/or distribute this software for
# any purpose with or without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
# AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
# DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
# OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE

require "chef/knife"
require_relative "helpers/base_vsphere_command"

# Lists all known data stores in datacenter with sizes
# VsphereVlanlist extends the BaseVspherecommand
class Chef::Knife::VsphereVlanList < Chef::Knife::BaseVsphereCommand
  banner "knife vsphere vlan list"

  deps do
    Chef::Knife::BaseVsphereCommand.load_deps
  end

  common_options

  # The main run method for vlan_list
  #
  def run
    $stdout.sync = true

    vim_connection
    dc = datacenter
    dc.network.each do |network|
      puts "#{ui.color("VLAN", :cyan)}: #{network.name}"
    end
  end
end
