#
# Author:: Seth Chisamore (<schisamo@chef.io>)
# Copyright:: Copyright (c) Chef Software Inc.
# License:: Apache License, Version 2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require "chef/knife"
require_relative "helpers/bootstrap_windows_base"

class Chef
  class Knife
    class BootstrapWindowsSsh < Bootstrap

      include Chef::Knife::BootstrapWindowsBase

      banner "knife bootstrap windows ssh FQDN (options) DEPRECATED"

      option :ssh_user,
        short: "-x USERNAME",
        long: "--ssh-user USERNAME",
        description: "The ssh username",
        default: "root"

      option :ssh_password,
        short: "-P PASSWORD",
        long: "--ssh-password PASSWORD",
        description: "The ssh password"

      option :ssh_port,
        short: "-p PORT",
        long: "--ssh-port PORT",
        description: "The ssh port",
        proc: Proc.new { |key| key.strip }

      option :ssh_gateway,
        short: "-G GATEWAY",
        long: "--ssh-gateway GATEWAY",
        description: "The ssh gateway"

      option :forward_agent,
        short: "-A",
        long: "--forward-agent",
        description: "Enable SSH agent forwarding",
        boolean: true

      option :identity_file,
        long: "--identity-file IDENTITY_FILE",
        description: "The SSH identity file used for authentication. [DEPRECATED] Use --ssh-identity-file instead."

      option :ssh_identity_file,
        short: "-i IDENTITY_FILE",
        long: "--ssh-identity-file IDENTITY_FILE",
        description: "The SSH identity file used for authentication"

      option :host_key_verify,
        long: "--[no-]host-key-verify",
        description: "Verify host key, enabled by default.",
        boolean: true,
        default: true

      def run
        Chef::Application.fatal!(<<~EOM
          *knife windows bootstrap ssh*
           Core Chef now supports bootstrapping Windows systems without a knife plugin

           Use 'knife bootstrap -o ssh' instead.

           For more detail https://github.com/chef/chef/blob/master/RELEASE_NOTES.md#knife-bootstrap
        EOM
                                )
      end

    end
  end
end
