# Copyright (c) 2018-2019 VMware, Inc.  All Rights Reserved.
# SPDX-License-Identifier: MIT

# DO NOT MODIFY. THIS CODE IS GENERATED. CHANGES WILL BE OVERWRITTEN.

# vcenter - VMware vCenter Server provides a centralized platform for managing your VMware vSphere environments


require 'date'

module VSphereAutomation
  module VCenter
    class VcenterVmHardwareBootInfo
    attr_accessor :type

    # Flag indicating whether to use EFI legacy boot mode. This field is optional and it is only relevant when the value of Boot.Info.type is EFI.
    attr_accessor :efi_legacy_boot

    attr_accessor :network_protocol

    # Delay in milliseconds before beginning the firmware boot process when the virtual machine is powered on. This delay may be used to provide a time window for users to connect to the virtual machine console and enter BIOS setup mode.
    attr_accessor :delay

    # Flag indicating whether the virtual machine will automatically retry the boot process after a failure.
    attr_accessor :_retry

    # Delay in milliseconds before retrying the boot process after a failure; applicable only when Boot.Info.retry is true.
    attr_accessor :retry_delay

    # Flag indicating whether the firmware boot process will automatically enter setup mode the next time the virtual machine boots. Note that this flag will automatically be reset to false once the virtual machine enters setup mode.
    attr_accessor :enter_setup_mode

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'type' => :'type',
        :'efi_legacy_boot' => :'efi_legacy_boot',
        :'network_protocol' => :'network_protocol',
        :'delay' => :'delay',
        :'_retry' => :'retry',
        :'retry_delay' => :'retry_delay',
        :'enter_setup_mode' => :'enter_setup_mode'
      }
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'type' => :'VcenterVmHardwareBootType',
        :'efi_legacy_boot' => :'Boolean',
        :'network_protocol' => :'VcenterVmHardwareBootNetworkProtocol',
        :'delay' => :'Integer',
        :'_retry' => :'Boolean',
        :'retry_delay' => :'Integer',
        :'enter_setup_mode' => :'Boolean'
      }
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      return unless attributes.is_a?(Hash)

      # convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h| h[k.to_sym] = v }

      if attributes.has_key?(:'type')
        self.type = attributes[:'type']
      end

      if attributes.has_key?(:'efi_legacy_boot')
        self.efi_legacy_boot = attributes[:'efi_legacy_boot']
      end

      if attributes.has_key?(:'network_protocol')
        self.network_protocol = attributes[:'network_protocol']
      end

      if attributes.has_key?(:'delay')
        self.delay = attributes[:'delay']
      end

      if attributes.has_key?(:'retry')
        self._retry = attributes[:'retry']
      end

      if attributes.has_key?(:'retry_delay')
        self.retry_delay = attributes[:'retry_delay']
      end

      if attributes.has_key?(:'enter_setup_mode')
        self.enter_setup_mode = attributes[:'enter_setup_mode']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      invalid_properties = Array.new
      if @type.nil?
        invalid_properties.push('invalid value for "type", type cannot be nil.')
      end

      if @delay.nil?
        invalid_properties.push('invalid value for "delay", delay cannot be nil.')
      end

      if @_retry.nil?
        invalid_properties.push('invalid value for "_retry", _retry cannot be nil.')
      end

      if @retry_delay.nil?
        invalid_properties.push('invalid value for "retry_delay", retry_delay cannot be nil.')
      end

      if @enter_setup_mode.nil?
        invalid_properties.push('invalid value for "enter_setup_mode", enter_setup_mode cannot be nil.')
      end

      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      return false if @type.nil?
      return false if @delay.nil?
      return false if @_retry.nil?
      return false if @retry_delay.nil?
      return false if @enter_setup_mode.nil?
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          type == o.type &&
          efi_legacy_boot == o.efi_legacy_boot &&
          network_protocol == o.network_protocol &&
          delay == o.delay &&
          _retry == o._retry &&
          retry_delay == o.retry_delay &&
          enter_setup_mode == o.enter_setup_mode
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Fixnum] Hash code
    def hash
      [type, efi_legacy_boot, network_protocol, delay, _retry, retry_delay, enter_setup_mode].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      self.class.openapi_types.each_pair do |key, type|
        if type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the the attribute
          # is documented as an array but the input is not
          if attributes[self.class.attribute_map[key]].is_a?(Array)
            self.send("#{key}=", attributes[self.class.attribute_map[key]].map { |v| _deserialize($1, v) })
          end
        elsif !attributes[self.class.attribute_map[key]].nil?
          self.send("#{key}=", _deserialize(type, attributes[self.class.attribute_map[key]]))
        end # or else data not found in attributes(hash), not an issue as the data can be optional
      end

      self
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def _deserialize(type, value)
      case type.to_sym
      when :DateTime
        DateTime.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :BOOLEAN, :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        temp_model = VSphereAutomation::VCenter.const_get(type).new
        temp_model.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        next if value.nil?
        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end
  end
end
