// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
//
// VMOptions=--verbose_debug

// Check that a try/finally is not treated as a try/catch:
// http://dartbug.com/45684.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/regress_45684_test.dart
//
const LINE_A = 32;
// AUTOGENERATED END

void tryFinally(Function() code) {
  // There is a synthetic try/catch inside try/finally but it is not authored
  // by the user, so debugger should not consider that this try/catch is
  // going to handle the exception.
  try {
    code();
  } finally {}
}

Never syncThrow() {
  throw 'Hello from syncThrow!'; // LINE_A
}

void testMain() {
  tryFinally(syncThrow);
}

final tests = <IsolateTest>[
  hasStoppedWithUnhandledException,
  stoppedAtLine(LINE_A),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'regress_45684_test.dart',
      testeeConcurrent: testMain,
      pauseOnUnhandledExceptions: true,
    );
