/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.xmldoclet.doctranslet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends ClassLoader {
    private JarFile jarFile;

    public JarClassLoader(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] loadClassData(String className) throws ClassNotFoundException {
        String classFileName = String.valueOf(className.replace('.', File.separatorChar)) + ".class";
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(classFileName);
            if (jarEntry != null) {
                return this.readFromStream(this.jarFile.getInputStream(jarEntry), jarEntry.getSize());
            }
        }
        catch (IOException iOException) {}
        throw new ClassNotFoundException(className);
    }

    private byte[] readFromStream(InputStream in, long size) throws IOException {
        byte[] result = new byte[(int)size];
        int nread = 0;
        int offset = 0;
        while ((long)offset < size && (nread = in.read(result, offset, (int)(size - (long)offset))) >= 0) {
            offset += nread;
        }
        in.close();
        return result;
    }
}

