/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.getopt;

import gnu.classpath.tools.getopt.Option;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;

public class OptionGroup {
    private static final String FILLER = "                                                                                ";
    private String name;
    ArrayList options = new ArrayList();

    OptionGroup() {
    }

    public OptionGroup(String name) {
        this.name = name;
    }

    protected static void formatText(PrintStream out, String text, int leftMargin) {
        OptionGroup.formatText(out, text, leftMargin, Locale.getDefault());
    }

    protected static void formatText(PrintStream out, String text, int leftMargin, Locale aLocale) {
        BreakIterator bit = BreakIterator.getLineInstance(aLocale);
        String[] lines = text.split("\n");
        int length = leftMargin;
        String leftPadding = FILLER.substring(0, leftMargin + 2);
        int i = 0;
        while (i < lines.length) {
            int finish;
            text = lines[i];
            bit.setText(text);
            int start = bit.first();
            while ((finish = bit.next()) != -1) {
                String word = text.substring(start, finish);
                if ((length += word.length()) >= 80) {
                    out.println();
                    out.print(leftPadding);
                    length = word.length() + leftMargin + 2;
                }
                out.print(word);
                start = finish;
            }
            out.println();
            if (i != lines.length - 1) {
                length = leftMargin + 2;
                out.print(leftPadding);
            }
            ++i;
        }
    }

    public void add(Option opt) {
        this.options.add(opt);
    }

    public void printHelp(PrintStream out, boolean longOnly) {
        String argName;
        int maxArgLen = 0;
        boolean shortOptionSeen = false;
        for (Option option : this.options) {
            if (option.getShortName() == '\u0000') continue;
            shortOptionSeen = true;
            break;
        }
        for (Option option : this.options) {
            argName = option.getArgumentName();
            int thisArgLen = 2;
            if (shortOptionSeen) {
                thisArgLen += 4;
            }
            if (option.getLongName() != null) {
                thisArgLen += 1 + option.getLongName().length();
                if (!longOnly) {
                    ++thisArgLen;
                }
            }
            if (argName != null) {
                thisArgLen += 1 + argName.length();
            }
            maxArgLen = Math.max(maxArgLen, thisArgLen);
        }
        if (this.name != null) {
            out.println(String.valueOf(this.name) + ":");
        }
        for (Option option : this.options) {
            argName = option.getArgumentName();
            int column = 0;
            if (option.getShortName() != '\u0000') {
                out.print("  -");
                out.print(option.getShortName());
                column += 4;
                if (option.getLongName() == null) {
                    if (argName != null) {
                        if (!option.isJoined()) {
                            out.print(' ');
                            ++column;
                        }
                        out.print(argName);
                        column += argName.length();
                    }
                    out.print("  ");
                } else {
                    out.print(", ");
                }
                column += 2;
            }
            while (column < (shortOptionSeen ? 6 : 2)) {
                out.print(' ');
                ++column;
            }
            if (option.getLongName() != null) {
                out.print(longOnly ? "-" : "--");
                out.print(option.getLongName());
                column += (longOnly ? 1 : 2) + option.getLongName().length();
                if (argName != null) {
                    out.print(" " + argName);
                    column += 1 + argName.length();
                }
            }
            out.print(FILLER.substring(0, maxArgLen + 4 - column));
            OptionGroup.formatText(out, option.getDescription(), maxArgLen + 4);
        }
    }
}

