/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.dssi;

import gnu.javax.sound.midi.dssi.DSSIMidiDeviceProvider;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

public class DSSISynthesizer
implements Synthesizer {
    long sohandle;
    long handle;
    private MidiDevice.Info info;
    MidiChannel[] channels = new MidiChannel[16];
    List<Soundbank> soundbanks = new ArrayList<Soundbank>();
    DSSISoundbank defaultSoundbank;

    static native void noteOn_(long var0, int var2, int var3, int var4);

    static native void noteOff_(long var0, int var2, int var3, int var4);

    static native void setPolyPressure_(long var0, int var2, int var3, int var4);

    static native int getPolyPressure_(long var0, int var2, int var3);

    static native void controlChange_(long var0, int var2, int var3, int var4);

    static native void open_(long var0);

    static native void close_(long var0);

    static native String getProgramName_(long var0, int var2);

    static native int getProgramBank_(long var0, int var2);

    static native int getProgramProgram_(long var0, int var2);

    static native void selectProgram_(long var0, int var2, int var3);

    public DSSISynthesizer(MidiDevice.Info info, String soname, long index) {
        String name;
        this.info = info;
        this.sohandle = DSSIMidiDeviceProvider.dlopen_(soname);
        this.handle = DSSIMidiDeviceProvider.getDSSIHandle_(this.sohandle, index);
        this.channels[0] = new DSSIMidiChannel(0);
        this.defaultSoundbank = new DSSISoundbank("name", "description", "vendor", "version");
        this.soundbanks.add(this.defaultSoundbank);
        int i = 0;
        do {
            if ((name = DSSISynthesizer.getProgramName_(this.sohandle, i)) == null) continue;
            this.defaultSoundbank.add(new DSSIInstrument(this.defaultSoundbank, new Patch(DSSISynthesizer.getProgramBank_(this.sohandle, i), DSSISynthesizer.getProgramProgram_(this.sohandle, i)), name));
            ++i;
        } while (name != null);
    }

    public int getMaxPolyphony() {
        return 0;
    }

    public long getLatency() {
        return 0L;
    }

    public MidiChannel[] getChannels() {
        return this.channels;
    }

    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (instrument.getSoundbank() != this.defaultSoundbank) {
            throw new IllegalArgumentException("Synthesizer doesn't support this instrument's soundbank");
        }
        Patch patch = instrument.getPatch();
        DSSISynthesizer.selectProgram_(this.sohandle, patch.getBank(), patch.getProgram());
        return true;
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        return false;
    }

    public Soundbank getDefaultSoundbank() {
        return this.defaultSoundbank;
    }

    public Instrument[] getAvailableInstruments() {
        ArrayList<Instrument> instruments = new ArrayList<Instrument>();
        for (Soundbank sb : this.soundbanks) {
            Instrument[] ins = sb.getInstruments();
            int i = 0;
            while (i < ins.length) {
                instruments.add(ins[i]);
                ++i;
            }
        }
        return instruments.toArray(new Instrument[instruments.size()]);
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        return false;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    public void open() throws MidiUnavailableException {
        DSSISynthesizer.open_(this.sohandle);
    }

    public void close() {
        DSSISynthesizer.close_(this.sohandle);
    }

    public boolean isOpen() {
        return false;
    }

    public long getMicrosecondPosition() {
        return 0L;
    }

    public int getMaxReceivers() {
        return 1;
    }

    public int getMaxTransmitters() {
        return 0;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return new DSSIReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return null;
    }

    class DSSIInstrument
    extends Instrument {
        DSSIInstrument(Soundbank soundbank, Patch patch, String name) {
            super(soundbank, patch, name, null);
        }

        public Object getData() {
            return null;
        }
    }

    public class DSSIMidiChannel
    implements MidiChannel {
        int channel = 0;

        public DSSIMidiChannel(int channel) {
            this.channel = channel;
        }

        public void noteOn(int noteNumber, int velocity) {
            DSSISynthesizer.noteOn_(DSSISynthesizer.this.sohandle, this.channel, noteNumber, velocity);
        }

        public void noteOff(int noteNumber, int velocity) {
            DSSISynthesizer.noteOff_(DSSISynthesizer.this.sohandle, this.channel, noteNumber, velocity);
        }

        public void noteOff(int noteNumber) {
            DSSISynthesizer.noteOff_(DSSISynthesizer.this.sohandle, this.channel, noteNumber, -1);
        }

        public void setPolyPressure(int noteNumber, int pressure) {
            DSSISynthesizer.setPolyPressure_(DSSISynthesizer.this.sohandle, this.channel, noteNumber, pressure);
        }

        public int getPolyPressure(int noteNumber) {
            return DSSISynthesizer.getPolyPressure_(DSSISynthesizer.this.sohandle, this.channel, noteNumber);
        }

        public void setChannelPressure(int pressure) {
        }

        public int getChannelPressure() {
            return 0;
        }

        public void controlChange(int controller, int value) {
            DSSISynthesizer.controlChange_(DSSISynthesizer.this.sohandle, this.channel, controller, value);
        }

        public int getController(int controller) {
            return 0;
        }

        public void programChange(int program) {
        }

        public void programChange(int bank, int program) {
        }

        public int getProgram() {
            return 0;
        }

        public void setPitchBend(int bend) {
        }

        public int getPitchBend() {
            return 0;
        }

        public void resetAllControllers() {
        }

        public void allNotesOff() {
        }

        public void allSoundOff() {
        }

        public boolean localControl(boolean on) {
            return false;
        }

        public void setMono(boolean on) {
        }

        public boolean getMono() {
            return false;
        }

        public void setOmni(boolean on) {
        }

        public boolean getOmni() {
            return false;
        }

        public void setMute(boolean mute) {
        }

        public boolean getMute() {
            return false;
        }

        public void setSolo(boolean solo) {
        }

        public boolean getSolo() {
            return false;
        }
    }

    class DSSIReceiver
    implements Receiver {
        DSSIReceiver() {
        }

        public void send(MidiMessage message, long timeStamp) throws IllegalStateException {
            if (message instanceof ShortMessage) {
                ShortMessage smessage = (ShortMessage)message;
                switch (message.getStatus()) {
                    case 144: {
                        int velocity = smessage.getData2();
                        if (velocity > 0) {
                            DSSISynthesizer.this.channels[smessage.getChannel()].noteOn(smessage.getData1(), smessage.getData2());
                            break;
                        }
                        DSSISynthesizer.this.channels[smessage.getChannel()].noteOff(smessage.getData1());
                        break;
                    }
                    case 176: {
                        DSSISynthesizer.this.channels[smessage.getChannel()].controlChange(smessage.getData1(), smessage.getData2());
                        break;
                    }
                    default: {
                        System.out.println("Unhandled message: " + message.getStatus());
                    }
                }
            }
        }

        public void close() {
        }
    }

    class DSSISoundbank
    implements Soundbank {
        private String name;
        private String description;
        private List<Instrument> instruments = new ArrayList<Instrument>();
        private List<SoundbankResource> resources = new ArrayList<SoundbankResource>();
        private String vendor;
        private String version;

        public DSSISoundbank(String name, String description, String vendor, String version) {
            this.name = name;
            this.description = description;
            this.vendor = vendor;
            this.version = version;
        }

        void add(Instrument instrument) {
            this.instruments.add(instrument);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getDescription() {
            return this.description;
        }

        public SoundbankResource[] getResources() {
            return this.resources.toArray(new SoundbankResource[this.resources.size()]);
        }

        public Instrument[] getInstruments() {
            return this.instruments.toArray(new Instrument[this.instruments.size()]);
        }

        public Instrument getInstrument(Patch patch) {
            for (Instrument i : this.instruments) {
                if (!i.getPatch().equals(patch)) continue;
                return i;
            }
            return null;
        }
    }
}

