/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentityScope
extends Identity {
    private static final long serialVersionUID = -2337346281189773310L;
    private static IdentityScope systemScope;

    protected IdentityScope() {
    }

    public IdentityScope(String name) {
        super(name);
    }

    public IdentityScope(String name, IdentityScope scope) throws KeyManagementException {
        super(name, scope);
    }

    public static IdentityScope getSystemScope() {
        return systemScope;
    }

    protected static void setSystemScope(IdentityScope scope) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setSystemScope");
        }
        systemScope = scope;
    }

    public abstract int size();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration<Identity> identities();

    @Override
    public String toString() {
        return String.valueOf(super.getName()) + " " + super.getScope().getName() + " " + this.size();
    }
}

