/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class Random
implements Serializable {
    private boolean haveNextNextGaussian;
    private double nextNextGaussian;
    private long seed;
    private static final long serialVersionUID = 3905348978240129619L;

    public Random() {
        this(System.currentTimeMillis());
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public synchronized void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.haveNextNextGaussian = false;
    }

    protected synchronized int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }

    public void nextBytes(byte[] bytes) {
        int random;
        int max = bytes.length & 0xFFFFFFFC;
        int i = 0;
        while (i < max) {
            random = this.next(32);
            bytes[i] = (byte)random;
            bytes[i + 1] = (byte)(random >> 8);
            bytes[i + 2] = (byte)(random >> 16);
            bytes[i + 3] = (byte)(random >> 24);
            i += 4;
        }
        if (max < bytes.length) {
            random = this.next(32);
            int j = max;
            while (j < bytes.length) {
                bytes[j] = (byte)random;
                random >>= 8;
                ++j;
            }
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0) {
        }
        double norm = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * norm;
        this.haveNextNextGaussian = true;
        return v1 * norm;
    }
}

