/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    private static FocusListener focusListener;
    private static EditorKit kit;
    Handler handler;
    RootView rootView;
    JTextComponent textComponent;
    private Insets cachedInsets;

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent c) {
        this.textComponent = (JTextComponent)c;
        if (this.rootView == null) {
            this.rootView = new RootView();
        }
        this.installDefaults();
        this.installFixedDefaults();
        if (this.handler == null) {
            this.handler = new Handler();
        }
        this.textComponent.addPropertyChangeListener(this.handler);
        Document doc = this.textComponent.getDocument();
        if (doc == null) {
            doc = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(doc);
        } else {
            doc.addDocumentListener(this.handler);
            this.modelChanged();
        }
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Insets margin;
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, String.valueOf(prefix) + ".background", String.valueOf(prefix) + ".foreground", String.valueOf(prefix) + ".font");
        LookAndFeel.installBorder(this.textComponent, String.valueOf(prefix) + ".border");
        Color color = this.textComponent.getCaretColor();
        if (color == null || color instanceof UIResource) {
            color = UIManager.getColor(String.valueOf(prefix) + ".caretForeground");
            this.textComponent.setCaretColor(color);
        }
        if ((color = this.textComponent.getDisabledTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(String.valueOf(prefix) + ".inactiveForeground");
            this.textComponent.setDisabledTextColor(color);
        }
        if ((color = this.textComponent.getSelectedTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(String.valueOf(prefix) + ".selectionForeground");
            this.textComponent.setSelectedTextColor(color);
        }
        if ((color = this.textComponent.getSelectionColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(String.valueOf(prefix) + ".selectionBackground");
            this.textComponent.setSelectionColor(color);
        }
        if ((margin = this.textComponent.getMargin()) == null || margin instanceof UIResource) {
            margin = UIManager.getInsets(String.valueOf(prefix) + ".margin");
            this.textComponent.setMargin(margin);
        }
    }

    private void installFixedDefaults() {
        Highlighter highlighter;
        String prefix = this.getPropertyPrefix();
        Caret caret = this.textComponent.getCaret();
        if (caret == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
            caret.setBlinkRate(UIManager.getInt(String.valueOf(prefix) + ".caretBlinkRate"));
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
    }

    protected void installListeners() {
        if (SystemProperties.getProperty("gnu.swing.text.no-xlike-clipboard") == null) {
            if (focusListener == null) {
                focusListener = new FocusHandler();
            }
            this.textComponent.addFocusListener(focusListener);
        }
    }

    protected String getKeymapName() {
        String fullClassName = this.getClass().getName();
        int index = fullClassName.lastIndexOf(46);
        String className = fullClassName.substring(index + 1);
        return className;
    }

    protected Keymap createKeymap() {
        String keymapName = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(keymapName);
        if (keymap == null) {
            Keymap parentMap = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(keymapName, parentMap);
            Object val = UIManager.get(String.valueOf(this.getPropertyPrefix()) + ".keyBindings");
            if (val != null && val instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])val;
                JTextComponent.loadKeymap(keymap, bindings, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void installKeyboardActions() {
        this.textComponent.setKeymap(this.createKeymap());
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap());
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    private ActionMap getActionMap() {
        String prefix = this.getPropertyPrefix();
        String amName = String.valueOf(prefix) + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(amName);
        if (am == null) {
            am = this.createActionMap();
            UIManager.put(amName, am);
        }
        ActionMapUIResource map = new ActionMapUIResource();
        map.setParent(am);
        return map;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource am = new ActionMapUIResource();
        Action[] actions = this.textComponent.getActions();
        int i = actions.length - 1;
        while (i >= 0) {
            Action action = actions[i];
            am.put(action.getValue("Name"), action);
            --i;
        }
        Action copyAction = TransferHandler.getCopyAction();
        am.put(copyAction.getValue("Name"), copyAction);
        Action cutAction = TransferHandler.getCutAction();
        am.put(cutAction.getValue("Name"), cutAction);
        Action pasteAction = TransferHandler.getPasteAction();
        am.put(pasteAction.getValue("Name"), pasteAction);
        return am;
    }

    private InputMap getInputMap() {
        InputMapUIResource im = new InputMapUIResource();
        String prefix = this.getPropertyPrefix();
        InputMap shared = (InputMap)SharedUIDefaults.get(String.valueOf(prefix) + ".focusInputMap");
        if (shared != null) {
            im.setParent(shared);
        }
        return im;
    }

    public void uninstallUI(JComponent component) {
        this.textComponent.removePropertyChangeListener(this.handler);
        this.textComponent.getDocument().removeDocumentListener(this.handler);
        this.rootView.setView(null);
        this.uninstallDefaults();
        this.uninstallFixedDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
        if (this.textComponent.getCaretColor() instanceof UIResource) {
            this.textComponent.setCaretColor(null);
        }
        if (this.textComponent.getSelectionColor() instanceof UIResource) {
            this.textComponent.setSelectionColor(null);
        }
        if (this.textComponent.getDisabledTextColor() instanceof UIResource) {
            this.textComponent.setDisabledTextColor(null);
        }
        if (this.textComponent.getSelectedTextColor() instanceof UIResource) {
            this.textComponent.setSelectedTextColor(null);
        }
        LookAndFeel.uninstallBorder(this.textComponent);
        if (this.textComponent.getMargin() instanceof UIResource) {
            this.textComponent.setMargin(null);
        }
    }

    private void uninstallFixedDefaults() {
        if (this.textComponent.getCaret() instanceof UIResource) {
            this.textComponent.setCaret(null);
        }
        if (this.textComponent.getHighlighter() instanceof UIResource) {
            this.textComponent.setHighlighter(null);
        }
    }

    protected void uninstallListeners() {
        if (focusListener != null) {
            this.textComponent.removeFocusListener(focusListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, null);
        SwingUtilities.replaceUIActionMap(this.textComponent, null);
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent c) {
        float h;
        float w;
        Dimension d = c.getSize();
        Insets i = c.getInsets();
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                this.rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
            } else {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            w = this.rootView.getPreferredSpan(0);
            h = this.rootView.getPreferredSpan(1);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        Dimension size = new Dimension((int)w + i.left + i.right, (int)h + i.top + i.bottom);
        return size;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = new Dimension();
        Insets i = c.getInsets();
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            d.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
            d.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return d;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = new Dimension();
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            d.width = (int)this.rootView.getMinimumSpan(0);
            d.height = (int)this.rootView.getMinimumSpan(1);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        Insets i = c.getInsets();
        d.width += i.left + i.right;
        d.height += i.top + i.bottom;
        return d;
    }

    public final void paint(Graphics g, JComponent c) {
        try {
            Document doc = this.textComponent.getDocument();
            if (doc instanceof AbstractDocument) {
                AbstractDocument aDoc = (AbstractDocument)doc;
                aDoc.readLock();
            }
            this.paintSafely(g);
        }
        finally {
            Document doc = this.textComponent.getDocument();
            if (doc instanceof AbstractDocument) {
                AbstractDocument aDoc = (AbstractDocument)doc;
                aDoc.readUnlock();
            }
        }
    }

    protected void paintSafely(Graphics g) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(g);
        }
        if (highlighter != null) {
            Color oldColor = g.getColor();
            highlighter.paint(g);
            g.setColor(oldColor);
        }
        this.rootView.paint(g, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(g);
        }
    }

    protected void paintBackground(Graphics g) {
        Color old = g.getColor();
        g.setColor(this.textComponent.getBackground());
        g.fillRect(0, 0, this.textComponent.getWidth(), this.textComponent.getHeight());
        g.setColor(old);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void damageRange(JTextComponent t, int p0, int p1) {
        this.damageRange(t, p0, p1, Position.Bias.Forward, Position.Bias.Backward);
    }

    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
        Rectangle alloc = this.getVisibleEditorRect();
        if (alloc != null) {
            Document doc = t.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            try {
                try {
                    this.rootView.setSize(alloc.width, alloc.height);
                    Shape damage = this.rootView.modelToView(p0, firstBias, p1, secondBias, alloc);
                    Rectangle r = damage instanceof Rectangle ? (Rectangle)damage : damage.getBounds();
                    this.textComponent.repaint(r.x, r.y, r.width, r.height);
                }
                catch (BadLocationException badLocationException) {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readUnlock();
                    }
                }
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent t) {
        if (kit == null) {
            kit = new DefaultEditorKit();
        }
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int offset = -1;
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                offset = this.rootView.getNextVisualPositionFrom(pos, b, alloc, direction, biasRet);
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return offset;
    }

    public View getRootView(JTextComponent t) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.modelToView(t, pos, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        Rectangle rect = null;
        try {
            Rectangle r = this.getVisibleEditorRect();
            if (r != null) {
                this.rootView.setSize(r.width, r.height);
                Shape s = this.rootView.modelToView(pos, r, bias);
                if (s != null) {
                    rect = s.getBounds();
                }
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return rect;
    }

    public int viewToModel(JTextComponent t, Point pt) {
        return this.viewToModel(t, pt, new Position.Bias[1]);
    }

    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        int offset = -1;
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                offset = this.rootView.viewToModel(pt.x, pt.y, alloc, biasReturn);
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return offset;
    }

    public View create(Element elem) {
        return null;
    }

    public View create(Element elem, int p0, int p1) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int width = this.textComponent.getWidth();
        int height = this.textComponent.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        Insets insets = this.textComponent.getInsets(this.cachedInsets);
        return new Rectangle(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory factory = this.rootView.getViewFactory();
        if (factory == null) {
            return;
        }
        Document doc = this.textComponent.getDocument();
        if (doc == null) {
            return;
        }
        Element elem = doc.getDefaultRootElement();
        if (elem == null) {
            return;
        }
        View view = factory.create(elem);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent ev) {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    private static class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            JTextComponent textComponent = (JTextComponent)e.getComponent();
            if (!e.isTemporary() && textComponent.getSelectionStart() != textComponent.getSelectionEnd()) {
                SecurityManager sm = System.getSecurityManager();
                try {
                    Clipboard cb;
                    if (sm != null) {
                        sm.checkSystemClipboardAccess();
                    }
                    if ((cb = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
                        StringSelection selection = new StringSelection(textComponent.getSelectedText());
                        cb.setContents(selection, selection);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (HeadlessException headlessException) {
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private class Handler
    implements PropertyChangeListener,
    DocumentListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("document")) {
                Object newValue;
                Object oldValue = event.getOldValue();
                if (oldValue != null) {
                    Document oldDoc = (Document)oldValue;
                    oldDoc.removeDocumentListener(BasicTextUI.this.handler);
                }
                if ((newValue = event.getNewValue()) != null) {
                    Document newDoc = (Document)newValue;
                    newDoc.addDocumentListener(BasicTextUI.this.handler);
                }
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(event);
        }

        public void changedUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.changedUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.insertUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.removeUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }
    }

    private class RootView
    extends View {
        private View view;

        public RootView() {
            super(null);
        }

        public ViewFactory getViewFactory() {
            ViewFactory factory = null;
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.getComponent());
            factory = editorKit.getViewFactory();
            if (factory == null) {
                factory = BasicTextUI.this;
            }
            return factory;
        }

        public void preferenceChanged(View v, boolean width, boolean height) {
            BasicTextUI.this.textComponent.revalidate();
        }

        public void setView(View v) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (v != null) {
                v.setParent(this);
            }
            this.view = v;
        }

        public View getView(int index) {
            return this.view;
        }

        public int getViewCount() {
            int count = 0;
            if (this.view != null) {
                count = 1;
            }
            return count;
        }

        public Container getContainer() {
            return BasicTextUI.this.textComponent;
        }

        public synchronized void setSize(float w, float h) {
            if (this.view != null) {
                this.view.setSize(w, h);
            }
        }

        public void paint(Graphics g, Shape s) {
            if (this.view != null) {
                Rectangle b = s instanceof Rectangle ? (Rectangle)s : s.getBounds();
                this.setSize(b.width, b.height);
                this.view.paint(g, s);
            }
        }

        public Shape modelToView(int position, Shape a, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(position, a, bias);
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            return this.view.viewToModel(x, y, a, b);
        }

        public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            if (this.view != null) {
                this.view.insertUpdate(ev, shape, vf);
            }
        }

        public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            if (this.view != null) {
                this.view.removeUpdate(ev, shape, vf);
            }
        }

        public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            if (this.view != null) {
                this.view.changedUpdate(ev, shape, vf);
            }
        }

        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int d, Position.Bias[] biasRet) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(pos, b, a, d, biasRet);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return BasicTextUI.this.textComponent.getDocument();
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int axis) {
            float span = 10.0f;
            if (this.view != null) {
                span = this.view.getPreferredSpan(axis);
            }
            return span;
        }

        public float getMinimumSpan(int axis) {
            float span = 10.0f;
            if (this.view != null) {
                span = this.view.getMinimumSpan(axis);
            }
            return span;
        }

        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }
    }
}

