/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FileSystemClassLoader
extends ClassLoader {
    private File[] pathComponents;

    public FileSystemClassLoader(String path) {
        ArrayList<File> components = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            List subComponents;
            File pathComponent = new File(st.nextToken());
            components.add(pathComponent);
            if (!pathComponent.exists() || pathComponent.isDirectory() || (subComponents = FileSystemClassLoader.tryGetJarFileClassPathComponents(pathComponent)) == null) continue;
            components.addAll(subComponents);
        }
        File[] componentArray = new File[components.size()];
        this.pathComponents = components.toArray(componentArray);
    }

    public FileSystemClassLoader(File[] pathComponents) {
        this.pathComponents = pathComponents;
        int i = 0;
        while (i < pathComponents.length) {
            if (!pathComponents[i].exists()) {
                System.err.println("WARNING: Path component '" + pathComponents[i] + "' not found.");
            }
            ++i;
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    public URL findResource(String name) {
        StreamInfo streamInfo = this.getResourceStream(name);
        if (streamInfo == null) {
            return super.findResource(name);
        }
        try {
            return streamInfo.getURL();
        }
        catch (MalformedURLException e) {
            System.err.println("WARNING: In FileSystemClassLoader: could not derive URL from file or jar entry: " + e.toString());
            return null;
        }
    }

    private byte[] readFromStream(InputStream in, long size) throws IOException {
        byte[] result = new byte[(int)size];
        int nread = 0;
        int offset = 0;
        while ((long)offset < size && (nread = in.read(result, offset, (int)(size - (long)offset))) >= 0) {
            offset += nread;
        }
        in.close();
        return result;
    }

    private byte[] readFromStream(StreamInfo streamInfo) throws IOException {
        InputStream in = streamInfo.openStream();
        long size = streamInfo.getSize();
        byte[] result = new byte[(int)size];
        int nread = 0;
        int offset = 0;
        while ((long)offset < size && (nread = in.read(result, offset, (int)(size - (long)offset))) >= 0) {
            offset += nread;
        }
        in.close();
        return result;
    }

    private StreamInfo getResourceStream(String path) {
        int i = 0;
        while (i < this.pathComponents.length) {
            try {
                File parent = this.pathComponents[i];
                if (parent.isDirectory()) {
                    File file = new File(parent, path);
                    if (file.exists()) {
                        return new FileStreamInfo(file);
                    }
                } else {
                    JarFile jarFile = new JarFile(parent, false, 1);
                    JarEntry jarEntry = jarFile.getJarEntry(path);
                    if (jarEntry != null) {
                        return new JarStreamInfo(parent, jarFile, jarEntry);
                    }
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return null;
    }

    private byte[] loadClassData(String className) throws ClassNotFoundException {
        String classFileName = String.valueOf(className.replace('.', File.separatorChar)) + ".class";
        StreamInfo streamInfo = this.getResourceStream(classFileName);
        try {
            if (streamInfo != null) {
                return this.readFromStream(streamInfo);
            }
        }
        catch (IOException iOException) {}
        throw new ClassNotFoundException(className);
    }

    private static List tryGetJarFileClassPathComponents(File file) {
        try {
            String classPath;
            Attributes mainAttributes;
            JarFile jarFile = new JarFile(file, false, 1);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                int token;
                LinkedList<File> result = new LinkedList<File>();
                StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(classPath));
                tokenizer.resetSyntax();
                tokenizer.wordChars(0, Integer.MAX_VALUE);
                tokenizer.whitespaceChars(9, 9);
                tokenizer.whitespaceChars(10, 10);
                tokenizer.whitespaceChars(13, 13);
                tokenizer.whitespaceChars(32, 32);
                tokenizer.quoteChar(34);
                while ((token = tokenizer.nextToken()) != -1) {
                    if (-3 != token) continue;
                    result.add(new File(file.getParentFile(), tokenizer.sval));
                }
                return result;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static class FileStreamInfo
    implements StreamInfo {
        File file;

        FileStreamInfo(File file) {
            this.file = file;
        }

        public InputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public long getSize() {
            return this.file.length();
        }

        public URL getURL() throws MalformedURLException {
            return this.file.toURL();
        }
    }

    private static class JarStreamInfo
    implements StreamInfo {
        private File file;
        private JarFile jarFile;
        private JarEntry jarEntry;

        JarStreamInfo(File file, JarFile jarFile, JarEntry jarEntry) {
            this.file = file;
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        public InputStream openStream() throws IOException {
            return this.jarFile.getInputStream(this.jarEntry);
        }

        public long getSize() {
            return this.jarEntry.getSize();
        }

        public URL getURL() throws MalformedURLException {
            String urlString = "jar:" + this.file.toURL() + "!/" + this.jarEntry.getName();
            return new URL(urlString);
        }
    }

    private static interface StreamInfo {
        public InputStream openStream() throws IOException;

        public long getSize();

        public URL getURL() throws MalformedURLException;
    }
}

