/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERWriter;
import gnu.java.security.x509.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERValue
implements DER {
    private final int tagClass;
    private final boolean constructed;
    private final int tag;
    private int length;
    private final Object value;
    private byte[] encoded;

    public DERValue(int tag, int length, Object value, byte[] encoded) {
        this.tagClass = tag & 0xC0;
        this.tag = tag & 0x1F;
        this.constructed = (tag & 0x20) == 32;
        this.length = length;
        this.value = value;
        if (encoded != null) {
            this.encoded = (byte[])encoded.clone();
        }
    }

    public DERValue(int tag, Object value) {
        this(tag, 0, value, null);
    }

    public int getExternalTag() {
        return this.tagClass | this.tag | (this.constructed ? 32 : 0);
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(ioe);
                throw iae;
            }
        }
        return this.length;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAs(int derType) throws IOException {
        byte[] encoded = this.getEncoded();
        encoded[0] = (byte)derType;
        return DERReader.read(encoded).getValue();
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(ioe);
                throw iae;
            }
        }
        return (byte[])this.encoded.clone();
    }

    public int getEncodedLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(ioe);
                throw iae;
            }
        }
        return this.encoded.length;
    }

    public String toString() {
        String start = "DERValue ( [";
        if (this.tagClass == 0) {
            start = String.valueOf(start) + "UNIVERSAL ";
        } else if (this.tagClass == 192) {
            start = String.valueOf(start) + "PRIVATE ";
        } else if (this.tagClass == 64) {
            start = String.valueOf(start) + "APPLICATION ";
        }
        start = String.valueOf(start) + this.tag + "] constructed=" + this.constructed + ", value=";
        start = this.constructed ? String.valueOf(start) + "\n" + Util.hexDump(this.getEncoded(), "\t") : String.valueOf(start) + this.value;
        return String.valueOf(start) + " )";
    }
}

