/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ServicePermission
extends Permission {
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private int flags;

    public ServicePermission(String name, String action) {
        super(name);
        this.parseActions(action);
    }

    public boolean implies(Permission perm) {
        if (!(perm instanceof ServicePermission)) {
            return false;
        }
        ServicePermission sp = (ServicePermission)perm;
        if ((this.flags & sp.flags) != sp.flags) {
            return false;
        }
        return this.getName().equals(sp.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServicePermission)) {
            return false;
        }
        ServicePermission sp = (ServicePermission)obj;
        return this.flags == sp.flags && this.getName().equals(sp.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.flags;
    }

    public String getActions() {
        if (this.flags == 3) {
            return "initiate,accept";
        }
        if (this.flags == 1) {
            return "initiate";
        }
        if (this.flags == 2) {
            return "accept";
        }
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(){
            private Vector permissions = new Vector();

            public void add(Permission perm) {
                if (this.isReadOnly()) {
                    throw new SecurityException("readonly");
                }
                if (!(perm instanceof ServicePermission)) {
                    throw new IllegalArgumentException("can only add DelegationPermissions");
                }
                this.permissions.add(perm);
            }

            public boolean implies(Permission perm) {
                if (!(perm instanceof ServicePermission)) {
                    return false;
                }
                Enumeration e = this.elements();
                while (e.hasMoreElements()) {
                    ServicePermission sp = (ServicePermission)e.nextElement();
                    if (!sp.implies(perm)) continue;
                    return true;
                }
                return false;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }

    private void parseActions(String actions) {
        StringTokenizer tok = new StringTokenizer(actions, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("accept".equals(token)) {
                this.flags |= 2;
                continue;
            }
            if ("initiate".equals(token)) {
                this.flags |= 1;
                continue;
            }
            throw new IllegalArgumentException("unrecognized token: " + token);
        }
    }
}

