/*
 * Copyright (c) 1999, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 *
 * Provides support for event notification when accessing naming and
 * directory services.
 *
 * <p>
 * This package defines the event notification operations of the Java Naming
 * and Directory Interface (JNDI). &nbsp;
 * JNDI provides naming and directory functionality to applications
 * written in the Java programming language. It is designed to be
 * independent of any specific naming or directory service
 * implementation. Thus a variety of services--new, emerging, and
 * already deployed ones--can be accessed in a common way.
 *
 * <h2>Naming Events</h2>
 * <p>
 * This package defines a {@code NamingEvent} class to represent an event
 * that is generated by a naming/directory service.
 * It also defines subinterfaces of {@code Context} and {@code DirContext},
 * called {@code EventContext} and {@code EventDirContext},
 * through which applications can register their interest in events
 * fired by the context.
 * <p>
 * {@code NamingEvent} represents an event that occurs in a
 * naming or directory service. There are two categories of naming events:
 * <ul>
 * <li>Those that affect the namespace (add/remove/rename an object)
 * <li>Those that affect the objects' contents.
 * </ul>
 * Each category of events is handled by a corresponding listener:
 * {@code NamespaceChangeListener}, {@code ObjectChangeListener}.
 * <p>
 * An application, for example, can register its interest in changes to
 * objects in a context as follows:
 * {@snippet :
 * EventContext src =
 *     (EventContext)(new InitialContext()).lookup("o=wiz,c=us");
 * src.addNamingListener("ou=users", EventContext.ONELEVEL_SCOPE,
 *     new ChangeHandler());
 * ...
 * class ChangeHandler implements ObjectChangeListener {
 *     public void objectChanged(NamingEvent evt) {
 *         System.out.println(evt.getNewBinding());
 *     }
 *     public void namingExceptionThrown(NamingExceptionEvent evt) {
 *         System.out.println(evt.getException());
 *     }
 * }
 * }
 *
 * <a id=THREADING></a>
 * <h3>Threading Issues</h3>
 *
 * When an event is dispatched to a listener, the listener method (such
 * as {@code objectChanged()}) may be executed in a thread other than the
 * one in which the call to {@code addNamingListener()} was executed.
 * The choice of which thread to use is made by the service provider.
 * When an event is dispatched to multiple listeners, the service provider
 * may choose (and is generally encouraged) to execute the listener methods
 * concurrently in separate threads.
 * <p>
 * When a listener instance invokes {@code NamingEvent.getEventContext()},
 * it must take into account the possibility that other threads will be
 * working with that context concurrently. Likewise, when a listener is
 * registered via {@code addNamingListener()}, the registering thread
 * must take into account the likely possibility that the service provider
 * will later invoke the listeners in newly-created threads. As {@code Context}
 * instances are not guaranteed to be thread-safe in general, all context
 * operations must be synchronized as needed.
 *
 * <h3>Exception Handling</h3>
 *
 * When a listener registers for events with a context, the context might
 * need to do some internal processing in order to collect information
 * required to generate the events. The context, for example, might need
 * to make a request to the server to register interest in changes
 * on the server that will eventually be translated into events.
 * If an exception occurs that prevents information about the events from
 * being collected, the listener will never be notified of the events.
 * When such an exception occurs, a {@code NamingExceptionEvent} is
 * fired to notify the listener. The listener's
 * {@code namingExceptionThrown()} method is invoked, as shown in the
 * sample code above,
 * and the listener is automatically deregistered.
 *
 * <h2>Package Specification</h2>
 *
 * The JNDI API Specification and related documents can be found in the
 * {@extLink jndi_overview JNDI documentation}.
 *
 * @since 1.3
 */
package javax.naming.event;
