/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.util.Map;
import jdk.jpackage.internal.util.CompositeProxy;

/**
 * Linux application launcher.
 * <p>
 * Use {@link #create} method to create objects implementing this interface.
 */
public interface LinuxLauncher extends Launcher, LinuxLauncherMixin {

    @Override
    default Map<String, String> extraAppImageFileData() {
        return shortcut().map(v -> {
            return Map.of("shortcut", Boolean.toString(v));
        }).orElseGet(Map::of);
    }

    /**
     * Constructs {@link LinuxLauncher} instance from the given
     * {@link Launcher} and {@link LinuxLauncherMixin} instances.
     *
     * @param launcher the generic application launcher
     * @param mixin Linux-specific details supplementing the generic application launcher
     * @return the proxy dispatching calls to the given objects
     */
    public static LinuxLauncher create(Launcher launcher, LinuxLauncherMixin mixin) {
        return CompositeProxy.create(LinuxLauncher.class, launcher, mixin);
    }
}
