# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InputConfiguration(object):
    """
    input documents configuration
    by default TXT files will be processed and this behaviour will not change in future after adding new types
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InputConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param document_types:
            The value to assign to the document_types property of this InputConfiguration.
        :type document_types: list[str]

        :param configuration:
            The value to assign to the configuration property of this InputConfiguration.
        :type configuration: dict(str, DocumentsConfiguration)

        """
        self.swagger_types = {
            'document_types': 'list[str]',
            'configuration': 'dict(str, DocumentsConfiguration)'
        }
        self.attribute_map = {
            'document_types': 'documentTypes',
            'configuration': 'configuration'
        }
        self._document_types = None
        self._configuration = None

    @property
    def document_types(self):
        """
        Gets the document_types of this InputConfiguration.
        Type of documents supported
        for this release only TXT,CSV  and one element is allowed here.
        for future scope this is marked as list


        :return: The document_types of this InputConfiguration.
        :rtype: list[str]
        """
        return self._document_types

    @document_types.setter
    def document_types(self, document_types):
        """
        Sets the document_types of this InputConfiguration.
        Type of documents supported
        for this release only TXT,CSV  and one element is allowed here.
        for future scope this is marked as list


        :param document_types: The document_types of this InputConfiguration.
        :type: list[str]
        """
        self._document_types = document_types

    @property
    def configuration(self):
        """
        Gets the configuration of this InputConfiguration.
        meta data about documents
         For CSV valid JSON format is {\"CSV\" :{inputColumn: \"reviewDetails\", rowId: \"reviewId\", copyColumnsToOutput: [\"reviewId\" \"userId\"] , delimiter: \",\"}
        Note: In future if new file types added we will update here in documentation about input file meta data


        :return: The configuration of this InputConfiguration.
        :rtype: dict(str, DocumentsConfiguration)
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this InputConfiguration.
        meta data about documents
         For CSV valid JSON format is {\"CSV\" :{inputColumn: \"reviewDetails\", rowId: \"reviewId\", copyColumnsToOutput: [\"reviewId\" \"userId\"] , delimiter: \",\"}
        Note: In future if new file types added we will update here in documentation about input file meta data


        :param configuration: The configuration of this InputConfiguration.
        :type: dict(str, DocumentsConfiguration)
        """
        self._configuration = configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
