# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentConfigFile(object):
    """
    An agent configuration file.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentConfigFile object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_type:
            The value to assign to the content_type property of this AgentConfigFile.
        :type content_type: str

        :param body:
            The value to assign to the body property of this AgentConfigFile.
        :type body: str

        """
        self.swagger_types = {
            'content_type': 'str',
            'body': 'str'
        }
        self.attribute_map = {
            'content_type': 'contentType',
            'body': 'body'
        }
        self._content_type = None
        self._body = None

    @property
    def content_type(self):
        """
        Gets the content_type of this AgentConfigFile.
        The MIME Content-Type that describes the content of the body field, for example, text/yaml or text/yaml; charset=utf-8


        :return: The content_type of this AgentConfigFile.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this AgentConfigFile.
        The MIME Content-Type that describes the content of the body field, for example, text/yaml or text/yaml; charset=utf-8


        :param content_type: The content_type of this AgentConfigFile.
        :type: str
        """
        self._content_type = content_type

    @property
    def body(self):
        """
        Gets the body of this AgentConfigFile.
        The Base64 encoded agent configuration file.


        :return: The body of this AgentConfigFile.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this AgentConfigFile.
        The Base64 encoded agent configuration file.


        :param body: The body of this AgentConfigFile.
        :type: str
        """
        self._body = body

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
