# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531

from .domain_type_capacity_report import DomainTypeCapacityReport
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SingleAdCapacityReport(DomainTypeCapacityReport):
    """
    Capacity report for a single-AD region.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SingleAdCapacityReport object with values from keyword arguments. The default value of the :py:attr:`~oci.bds.models.SingleAdCapacityReport.domain_type` attribute
        of this class is ``SINGLE_AD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param domain_type:
            The value to assign to the domain_type property of this SingleAdCapacityReport.
            Allowed values for this property are: "MULTI_AD", "SINGLE_AD"
        :type domain_type: str

        :param fault_domain:
            The value to assign to the fault_domain property of this SingleAdCapacityReport.
        :type fault_domain: str

        :param capacity_availability:
            The value to assign to the capacity_availability property of this SingleAdCapacityReport.
        :type capacity_availability: oci.bds.models.CapacityAvailability

        """
        self.swagger_types = {
            'domain_type': 'str',
            'fault_domain': 'str',
            'capacity_availability': 'CapacityAvailability'
        }
        self.attribute_map = {
            'domain_type': 'domainType',
            'fault_domain': 'faultDomain',
            'capacity_availability': 'capacityAvailability'
        }
        self._domain_type = None
        self._fault_domain = None
        self._capacity_availability = None
        self._domain_type = 'SINGLE_AD'

    @property
    def fault_domain(self):
        """
        **[Required]** Gets the fault_domain of this SingleAdCapacityReport.
        The fault domain for the capacity report.


        :return: The fault_domain of this SingleAdCapacityReport.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this SingleAdCapacityReport.
        The fault domain for the capacity report.


        :param fault_domain: The fault_domain of this SingleAdCapacityReport.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def capacity_availability(self):
        """
        **[Required]** Gets the capacity_availability of this SingleAdCapacityReport.

        :return: The capacity_availability of this SingleAdCapacityReport.
        :rtype: oci.bds.models.CapacityAvailability
        """
        return self._capacity_availability

    @capacity_availability.setter
    def capacity_availability(self, capacity_availability):
        """
        Sets the capacity_availability of this SingleAdCapacityReport.

        :param capacity_availability: The capacity_availability of this SingleAdCapacityReport.
        :type: oci.bds.models.CapacityAvailability
        """
        self._capacity_availability = capacity_availability

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
