# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedOccHandoverResourceBlock(object):
    """
    Details about the resource block that was handed over.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedOccHandoverResourceBlock object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param occ_handover_resource_block_id:
            The value to assign to the occ_handover_resource_block_id property of this AssociatedOccHandoverResourceBlock.
        :type occ_handover_resource_block_id: str

        :param handover_quantity:
            The value to assign to the handover_quantity property of this AssociatedOccHandoverResourceBlock.
        :type handover_quantity: int

        """
        self.swagger_types = {
            'occ_handover_resource_block_id': 'str',
            'handover_quantity': 'int'
        }
        self.attribute_map = {
            'occ_handover_resource_block_id': 'occHandoverResourceBlockId',
            'handover_quantity': 'handoverQuantity'
        }
        self._occ_handover_resource_block_id = None
        self._handover_quantity = None

    @property
    def occ_handover_resource_block_id(self):
        """
        Gets the occ_handover_resource_block_id of this AssociatedOccHandoverResourceBlock.
        The OCID of the handed over resource block.


        :return: The occ_handover_resource_block_id of this AssociatedOccHandoverResourceBlock.
        :rtype: str
        """
        return self._occ_handover_resource_block_id

    @occ_handover_resource_block_id.setter
    def occ_handover_resource_block_id(self, occ_handover_resource_block_id):
        """
        Sets the occ_handover_resource_block_id of this AssociatedOccHandoverResourceBlock.
        The OCID of the handed over resource block.


        :param occ_handover_resource_block_id: The occ_handover_resource_block_id of this AssociatedOccHandoverResourceBlock.
        :type: str
        """
        self._occ_handover_resource_block_id = occ_handover_resource_block_id

    @property
    def handover_quantity(self):
        """
        Gets the handover_quantity of this AssociatedOccHandoverResourceBlock.
        The total quantity of the resource that was made available to the customer as part of this resource block


        :return: The handover_quantity of this AssociatedOccHandoverResourceBlock.
        :rtype: int
        """
        return self._handover_quantity

    @handover_quantity.setter
    def handover_quantity(self, handover_quantity):
        """
        Sets the handover_quantity of this AssociatedOccHandoverResourceBlock.
        The total quantity of the resource that was made available to the customer as part of this resource block


        :param handover_quantity: The handover_quantity of this AssociatedOccHandoverResourceBlock.
        :type: int
        """
        self._handover_quantity = handover_quantity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
