# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .placement_constraint_details import PlacementConstraintDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeBareMetalHostPlacementConstraintDetails(PlacementConstraintDetails):
    """
    The details for providing placement constraints using the compute bare metal host OCID.
    This placement constraint is only applicable during the launch operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeBareMetalHostPlacementConstraintDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.core.models.ComputeBareMetalHostPlacementConstraintDetails.type` attribute
        of this class is ``COMPUTE_BARE_METAL_HOST`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ComputeBareMetalHostPlacementConstraintDetails.
        :type type: str

        :param compute_bare_metal_host_id:
            The value to assign to the compute_bare_metal_host_id property of this ComputeBareMetalHostPlacementConstraintDetails.
        :type compute_bare_metal_host_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'compute_bare_metal_host_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'compute_bare_metal_host_id': 'computeBareMetalHostId'
        }
        self._type = None
        self._compute_bare_metal_host_id = None
        self._type = 'COMPUTE_BARE_METAL_HOST'

    @property
    def compute_bare_metal_host_id(self):
        """
        **[Required]** Gets the compute_bare_metal_host_id of this ComputeBareMetalHostPlacementConstraintDetails.
        The OCID of the compute bare metal host. This is only available for dedicated capacity customers.


        :return: The compute_bare_metal_host_id of this ComputeBareMetalHostPlacementConstraintDetails.
        :rtype: str
        """
        return self._compute_bare_metal_host_id

    @compute_bare_metal_host_id.setter
    def compute_bare_metal_host_id(self, compute_bare_metal_host_id):
        """
        Sets the compute_bare_metal_host_id of this ComputeBareMetalHostPlacementConstraintDetails.
        The OCID of the compute bare metal host. This is only available for dedicated capacity customers.


        :param compute_bare_metal_host_id: The compute_bare_metal_host_id of this ComputeBareMetalHostPlacementConstraintDetails.
        :type: str
        """
        self._compute_bare_metal_host_id = compute_bare_metal_host_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
