# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateBaselineDiffsPerTarget(object):
    """
    The results of the comparison between two security assessment resources, and one of them is TEMPLATE_BASELINE type.
    """

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "EVALUATE"
    SEVERITY_EVALUATE = "EVALUATE"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "ADVISORY"
    SEVERITY_ADVISORY = "ADVISORY"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "PASS"
    SEVERITY_PASS = "PASS"

    #: A constant which can be used with the severity property of a TemplateBaselineDiffsPerTarget.
    #: This constant has a value of "DEFERRED"
    SEVERITY_DEFERRED = "DEFERRED"

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateBaselineDiffsPerTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this TemplateBaselineDiffsPerTarget.
        :type target_id: str

        :param key:
            The value to assign to the key property of this TemplateBaselineDiffsPerTarget.
        :type key: str

        :param title:
            The value to assign to the title property of this TemplateBaselineDiffsPerTarget.
        :type title: str

        :param severity:
            The value to assign to the severity property of this TemplateBaselineDiffsPerTarget.
            Allowed values for this property are: "HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'key': 'str',
            'title': 'str',
            'severity': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'key': 'key',
            'title': 'title',
            'severity': 'severity'
        }
        self._target_id = None
        self._key = None
        self._title = None
        self._severity = None

    @property
    def target_id(self):
        """
        Gets the target_id of this TemplateBaselineDiffsPerTarget.
        The OCID of the target database.


        :return: The target_id of this TemplateBaselineDiffsPerTarget.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this TemplateBaselineDiffsPerTarget.
        The OCID of the target database.


        :param target_id: The target_id of this TemplateBaselineDiffsPerTarget.
        :type: str
        """
        self._target_id = target_id

    @property
    def key(self):
        """
        Gets the key of this TemplateBaselineDiffsPerTarget.
        A unique identifier for the finding. This is common for the finding across targets.


        :return: The key of this TemplateBaselineDiffsPerTarget.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this TemplateBaselineDiffsPerTarget.
        A unique identifier for the finding. This is common for the finding across targets.


        :param key: The key of this TemplateBaselineDiffsPerTarget.
        :type: str
        """
        self._key = key

    @property
    def title(self):
        """
        Gets the title of this TemplateBaselineDiffsPerTarget.
        The short title for the finding.


        :return: The title of this TemplateBaselineDiffsPerTarget.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this TemplateBaselineDiffsPerTarget.
        The short title for the finding.


        :param title: The title of this TemplateBaselineDiffsPerTarget.
        :type: str
        """
        self._title = title

    @property
    def severity(self):
        """
        Gets the severity of this TemplateBaselineDiffsPerTarget.
        The severity of this diff.

        Allowed values for this property are: "HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this TemplateBaselineDiffsPerTarget.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this TemplateBaselineDiffsPerTarget.
        The severity of this diff.


        :param severity: The severity of this TemplateBaselineDiffsPerTarget.
        :type: str
        """
        allowed_values = ["HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
