# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .auth_configuration import AuthConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdcsCustomServiceAuthConfiguration(AuthConfiguration):
    """
    Using existing Oracle Cloud Service for online prediction AuthN/Z
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdcsCustomServiceAuthConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.IdcsCustomServiceAuthConfiguration.type` attribute
        of this class is ``IDCS_CUSTOM_SERVICE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IdcsCustomServiceAuthConfiguration.
            Allowed values for this property are: "IDCS", "IAM", "IDCS_CUSTOM_SERVICE"
        :type type: str

        :param idcs_stripe_uri:
            The value to assign to the idcs_stripe_uri property of this IdcsCustomServiceAuthConfiguration.
        :type idcs_stripe_uri: str

        :param audience:
            The value to assign to the audience property of this IdcsCustomServiceAuthConfiguration.
        :type audience: str

        :param scope:
            The value to assign to the scope property of this IdcsCustomServiceAuthConfiguration.
        :type scope: str

        :param application_name:
            The value to assign to the application_name property of this IdcsCustomServiceAuthConfiguration.
        :type application_name: str

        :param role_name:
            The value to assign to the role_name property of this IdcsCustomServiceAuthConfiguration.
        :type role_name: str

        """
        self.swagger_types = {
            'type': 'str',
            'idcs_stripe_uri': 'str',
            'audience': 'str',
            'scope': 'str',
            'application_name': 'str',
            'role_name': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'idcs_stripe_uri': 'idcsStripeUri',
            'audience': 'audience',
            'scope': 'scope',
            'application_name': 'applicationName',
            'role_name': 'roleName'
        }
        self._type = None
        self._idcs_stripe_uri = None
        self._audience = None
        self._scope = None
        self._application_name = None
        self._role_name = None
        self._type = 'IDCS_CUSTOM_SERVICE'

    @property
    def idcs_stripe_uri(self):
        """
        **[Required]** Gets the idcs_stripe_uri of this IdcsCustomServiceAuthConfiguration.
        URI of IDCS Stripe


        :return: The idcs_stripe_uri of this IdcsCustomServiceAuthConfiguration.
        :rtype: str
        """
        return self._idcs_stripe_uri

    @idcs_stripe_uri.setter
    def idcs_stripe_uri(self, idcs_stripe_uri):
        """
        Sets the idcs_stripe_uri of this IdcsCustomServiceAuthConfiguration.
        URI of IDCS Stripe


        :param idcs_stripe_uri: The idcs_stripe_uri of this IdcsCustomServiceAuthConfiguration.
        :type: str
        """
        self._idcs_stripe_uri = idcs_stripe_uri

    @property
    def audience(self):
        """
        **[Required]** Gets the audience of this IdcsCustomServiceAuthConfiguration.
        Audience of the IDCS application


        :return: The audience of this IdcsCustomServiceAuthConfiguration.
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """
        Sets the audience of this IdcsCustomServiceAuthConfiguration.
        Audience of the IDCS application


        :param audience: The audience of this IdcsCustomServiceAuthConfiguration.
        :type: str
        """
        self._audience = audience

    @property
    def scope(self):
        """
        **[Required]** Gets the scope of this IdcsCustomServiceAuthConfiguration.
        Scope of the IDCS application


        :return: The scope of this IdcsCustomServiceAuthConfiguration.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this IdcsCustomServiceAuthConfiguration.
        Scope of the IDCS application


        :param scope: The scope of this IdcsCustomServiceAuthConfiguration.
        :type: str
        """
        self._scope = scope

    @property
    def application_name(self):
        """
        **[Required]** Gets the application_name of this IdcsCustomServiceAuthConfiguration.
        Name of the IDCS application


        :return: The application_name of this IdcsCustomServiceAuthConfiguration.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """
        Sets the application_name of this IdcsCustomServiceAuthConfiguration.
        Name of the IDCS application


        :param application_name: The application_name of this IdcsCustomServiceAuthConfiguration.
        :type: str
        """
        self._application_name = application_name

    @property
    def role_name(self):
        """
        **[Required]** Gets the role_name of this IdcsCustomServiceAuthConfiguration.
        Name of the IDCS application role


        :return: The role_name of this IdcsCustomServiceAuthConfiguration.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name):
        """
        Sets the role_name of this IdcsCustomServiceAuthConfiguration.
        Name of the IDCS application role


        :param role_name: The role_name of this IdcsCustomServiceAuthConfiguration.
        :type: str
        """
        self._role_name = role_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
