# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActionOrderDetails(object):
    """
    Describes the ordering list of action resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ActionOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_order:
            The value to assign to the action_order property of this ActionOrderDetails.
        :type action_order: int

        :param action_resource_id:
            The value to assign to the action_resource_id property of this ActionOrderDetails.
        :type action_resource_id: str

        """
        self.swagger_types = {
            'action_order': 'int',
            'action_resource_id': 'str'
        }
        self.attribute_map = {
            'action_order': 'actionOrder',
            'action_resource_id': 'actionResourceId'
        }
        self._action_order = None
        self._action_resource_id = None

    @property
    def action_order(self):
        """
        Gets the action_order of this ActionOrderDetails.
        The priority order of the action resource.


        :return: The action_order of this ActionOrderDetails.
        :rtype: int
        """
        return self._action_order

    @action_order.setter
    def action_order(self, action_order):
        """
        Sets the action_order of this ActionOrderDetails.
        The priority order of the action resource.


        :param action_order: The action_order of this ActionOrderDetails.
        :type: int
        """
        self._action_order = action_order

    @property
    def action_resource_id(self):
        """
        Gets the action_resource_id of this ActionOrderDetails.
        The `OCID`__ of the action resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The action_resource_id of this ActionOrderDetails.
        :rtype: str
        """
        return self._action_resource_id

    @action_resource_id.setter
    def action_resource_id(self, action_resource_id):
        """
        Sets the action_resource_id of this ActionOrderDetails.
        The `OCID`__ of the action resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param action_resource_id: The action_resource_id of this ActionOrderDetails.
        :type: str
        """
        self._action_resource_id = action_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
