# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .encryption_key_location_details import EncryptionKeyLocationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AzureEncryptionKeyDetails(EncryptionKeyLocationDetails):
    """
    Details for Azure Input
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AzureEncryptionKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.AzureEncryptionKeyDetails.provider_type` attribute
        of this class is ``AZURE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider_type:
            The value to assign to the provider_type property of this AzureEncryptionKeyDetails.
            Allowed values for this property are: "EXTERNAL", "AZURE", "GCP", "AWS"
        :type provider_type: str

        :param azure_encryption_key_id:
            The value to assign to the azure_encryption_key_id property of this AzureEncryptionKeyDetails.
        :type azure_encryption_key_id: str

        """
        self.swagger_types = {
            'provider_type': 'str',
            'azure_encryption_key_id': 'str'
        }
        self.attribute_map = {
            'provider_type': 'providerType',
            'azure_encryption_key_id': 'azureEncryptionKeyId'
        }
        self._provider_type = None
        self._azure_encryption_key_id = None
        self._provider_type = 'AZURE'

    @property
    def azure_encryption_key_id(self):
        """
        **[Required]** Gets the azure_encryption_key_id of this AzureEncryptionKeyDetails.
        Provide the key OCID of a registered Azure key.


        :return: The azure_encryption_key_id of this AzureEncryptionKeyDetails.
        :rtype: str
        """
        return self._azure_encryption_key_id

    @azure_encryption_key_id.setter
    def azure_encryption_key_id(self, azure_encryption_key_id):
        """
        Sets the azure_encryption_key_id of this AzureEncryptionKeyDetails.
        Provide the key OCID of a registered Azure key.


        :param azure_encryption_key_id: The azure_encryption_key_id of this AzureEncryptionKeyDetails.
        :type: str
        """
        self._azure_encryption_key_id = azure_encryption_key_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
