# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupDestinationDetailsSummary(object):
    """
    Information about the backup destination associated with the Autonomous Container Database.
    """

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "NFS"
    TYPE_NFS = "NFS"

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "RECOVERY_APPLIANCE"
    TYPE_RECOVERY_APPLIANCE = "RECOVERY_APPLIANCE"

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "OBJECT_STORE"
    TYPE_OBJECT_STORE = "OBJECT_STORE"

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "LOCAL"
    TYPE_LOCAL = "LOCAL"

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "DBRS"
    TYPE_DBRS = "DBRS"

    #: A constant which can be used with the type property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "AWS_S3"
    TYPE_AWS_S3 = "AWS_S3"

    #: A constant which can be used with the backup_retention_policy_on_terminate property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "RETAIN_PER_RETENTION_WINDOW"
    BACKUP_RETENTION_POLICY_ON_TERMINATE_RETAIN_PER_RETENTION_WINDOW = "RETAIN_PER_RETENTION_WINDOW"

    #: A constant which can be used with the backup_retention_policy_on_terminate property of a BackupDestinationDetailsSummary.
    #: This constant has a value of "RETAIN_FOR_72_HOURS"
    BACKUP_RETENTION_POLICY_ON_TERMINATE_RETAIN_FOR_72_HOURS = "RETAIN_FOR_72_HOURS"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupDestinationDetailsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_destination_attach_history:
            The value to assign to the backup_destination_attach_history property of this BackupDestinationDetailsSummary.
        :type backup_destination_attach_history: list[datetime]

        :param space_utilized_in_gbs:
            The value to assign to the space_utilized_in_gbs property of this BackupDestinationDetailsSummary.
        :type space_utilized_in_gbs: int

        :param time_at_which_storage_details_are_updated:
            The value to assign to the time_at_which_storage_details_are_updated property of this BackupDestinationDetailsSummary.
        :type time_at_which_storage_details_are_updated: datetime

        :param type:
            The value to assign to the type property of this BackupDestinationDetailsSummary.
            Allowed values for this property are: "NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS", "AWS_S3", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param id:
            The value to assign to the id property of this BackupDestinationDetailsSummary.
        :type id: str

        :param vpc_user:
            The value to assign to the vpc_user property of this BackupDestinationDetailsSummary.
        :type vpc_user: str

        :param vpc_password:
            The value to assign to the vpc_password property of this BackupDestinationDetailsSummary.
        :type vpc_password: str

        :param internet_proxy:
            The value to assign to the internet_proxy property of this BackupDestinationDetailsSummary.
        :type internet_proxy: str

        :param dbrs_policy_id:
            The value to assign to the dbrs_policy_id property of this BackupDestinationDetailsSummary.
        :type dbrs_policy_id: str

        :param is_retention_lock_enabled:
            The value to assign to the is_retention_lock_enabled property of this BackupDestinationDetailsSummary.
        :type is_retention_lock_enabled: bool

        :param backup_retention_policy_on_terminate:
            The value to assign to the backup_retention_policy_on_terminate property of this BackupDestinationDetailsSummary.
            Allowed values for this property are: "RETAIN_PER_RETENTION_WINDOW", "RETAIN_FOR_72_HOURS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type backup_retention_policy_on_terminate: str

        :param is_remote:
            The value to assign to the is_remote property of this BackupDestinationDetailsSummary.
        :type is_remote: bool

        :param remote_region:
            The value to assign to the remote_region property of this BackupDestinationDetailsSummary.
        :type remote_region: str

        """
        self.swagger_types = {
            'backup_destination_attach_history': 'list[datetime]',
            'space_utilized_in_gbs': 'int',
            'time_at_which_storage_details_are_updated': 'datetime',
            'type': 'str',
            'id': 'str',
            'vpc_user': 'str',
            'vpc_password': 'str',
            'internet_proxy': 'str',
            'dbrs_policy_id': 'str',
            'is_retention_lock_enabled': 'bool',
            'backup_retention_policy_on_terminate': 'str',
            'is_remote': 'bool',
            'remote_region': 'str'
        }
        self.attribute_map = {
            'backup_destination_attach_history': 'backupDestinationAttachHistory',
            'space_utilized_in_gbs': 'spaceUtilizedInGBs',
            'time_at_which_storage_details_are_updated': 'timeAtWhichStorageDetailsAreUpdated',
            'type': 'type',
            'id': 'id',
            'vpc_user': 'vpcUser',
            'vpc_password': 'vpcPassword',
            'internet_proxy': 'internetProxy',
            'dbrs_policy_id': 'dbrsPolicyId',
            'is_retention_lock_enabled': 'isRetentionLockEnabled',
            'backup_retention_policy_on_terminate': 'backupRetentionPolicyOnTerminate',
            'is_remote': 'isRemote',
            'remote_region': 'remoteRegion'
        }
        self._backup_destination_attach_history = None
        self._space_utilized_in_gbs = None
        self._time_at_which_storage_details_are_updated = None
        self._type = None
        self._id = None
        self._vpc_user = None
        self._vpc_password = None
        self._internet_proxy = None
        self._dbrs_policy_id = None
        self._is_retention_lock_enabled = None
        self._backup_retention_policy_on_terminate = None
        self._is_remote = None
        self._remote_region = None

    @property
    def backup_destination_attach_history(self):
        """
        Gets the backup_destination_attach_history of this BackupDestinationDetailsSummary.
        The timestamps at which this backup destination is used as the preferred destination to host the Autonomous Container Database backups.


        :return: The backup_destination_attach_history of this BackupDestinationDetailsSummary.
        :rtype: list[datetime]
        """
        return self._backup_destination_attach_history

    @backup_destination_attach_history.setter
    def backup_destination_attach_history(self, backup_destination_attach_history):
        """
        Sets the backup_destination_attach_history of this BackupDestinationDetailsSummary.
        The timestamps at which this backup destination is used as the preferred destination to host the Autonomous Container Database backups.


        :param backup_destination_attach_history: The backup_destination_attach_history of this BackupDestinationDetailsSummary.
        :type: list[datetime]
        """
        self._backup_destination_attach_history = backup_destination_attach_history

    @property
    def space_utilized_in_gbs(self):
        """
        Gets the space_utilized_in_gbs of this BackupDestinationDetailsSummary.
        The total space utilized (in GBs) by this Autonomous Container Database on this backup destination, rounded to the nearest integer.


        :return: The space_utilized_in_gbs of this BackupDestinationDetailsSummary.
        :rtype: int
        """
        return self._space_utilized_in_gbs

    @space_utilized_in_gbs.setter
    def space_utilized_in_gbs(self, space_utilized_in_gbs):
        """
        Sets the space_utilized_in_gbs of this BackupDestinationDetailsSummary.
        The total space utilized (in GBs) by this Autonomous Container Database on this backup destination, rounded to the nearest integer.


        :param space_utilized_in_gbs: The space_utilized_in_gbs of this BackupDestinationDetailsSummary.
        :type: int
        """
        self._space_utilized_in_gbs = space_utilized_in_gbs

    @property
    def time_at_which_storage_details_are_updated(self):
        """
        Gets the time_at_which_storage_details_are_updated of this BackupDestinationDetailsSummary.
        The latest timestamp when the backup destination details, such as 'spaceUtilized,' are updated.


        :return: The time_at_which_storage_details_are_updated of this BackupDestinationDetailsSummary.
        :rtype: datetime
        """
        return self._time_at_which_storage_details_are_updated

    @time_at_which_storage_details_are_updated.setter
    def time_at_which_storage_details_are_updated(self, time_at_which_storage_details_are_updated):
        """
        Sets the time_at_which_storage_details_are_updated of this BackupDestinationDetailsSummary.
        The latest timestamp when the backup destination details, such as 'spaceUtilized,' are updated.


        :param time_at_which_storage_details_are_updated: The time_at_which_storage_details_are_updated of this BackupDestinationDetailsSummary.
        :type: datetime
        """
        self._time_at_which_storage_details_are_updated = time_at_which_storage_details_are_updated

    @property
    def type(self):
        """
        **[Required]** Gets the type of this BackupDestinationDetailsSummary.
        Type of the database backup destination.

        Allowed values for this property are: "NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS", "AWS_S3", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BackupDestinationDetailsSummary.
        Type of the database backup destination.


        :param type: The type of this BackupDestinationDetailsSummary.
        :type: str
        """
        allowed_values = ["NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS", "AWS_S3"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def id(self):
        """
        Gets the id of this BackupDestinationDetailsSummary.
        The `OCID`__ of the backup destination.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BackupDestinationDetailsSummary.
        The `OCID`__ of the backup destination.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._id = id

    @property
    def vpc_user(self):
        """
        Gets the vpc_user of this BackupDestinationDetailsSummary.
        For a RECOVERY_APPLIANCE backup destination, the Virtual Private Catalog (VPC) user that is used to access the Recovery Appliance.


        :return: The vpc_user of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._vpc_user

    @vpc_user.setter
    def vpc_user(self, vpc_user):
        """
        Sets the vpc_user of this BackupDestinationDetailsSummary.
        For a RECOVERY_APPLIANCE backup destination, the Virtual Private Catalog (VPC) user that is used to access the Recovery Appliance.


        :param vpc_user: The vpc_user of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._vpc_user = vpc_user

    @property
    def vpc_password(self):
        """
        Gets the vpc_password of this BackupDestinationDetailsSummary.
        For a RECOVERY_APPLIANCE backup destination, the password for the VPC user that is used to access the Recovery Appliance.


        :return: The vpc_password of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._vpc_password

    @vpc_password.setter
    def vpc_password(self, vpc_password):
        """
        Sets the vpc_password of this BackupDestinationDetailsSummary.
        For a RECOVERY_APPLIANCE backup destination, the password for the VPC user that is used to access the Recovery Appliance.


        :param vpc_password: The vpc_password of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._vpc_password = vpc_password

    @property
    def internet_proxy(self):
        """
        Gets the internet_proxy of this BackupDestinationDetailsSummary.
        Proxy URL to connect to object store.


        :return: The internet_proxy of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._internet_proxy

    @internet_proxy.setter
    def internet_proxy(self, internet_proxy):
        """
        Sets the internet_proxy of this BackupDestinationDetailsSummary.
        Proxy URL to connect to object store.


        :param internet_proxy: The internet_proxy of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._internet_proxy = internet_proxy

    @property
    def dbrs_policy_id(self):
        """
        Gets the dbrs_policy_id of this BackupDestinationDetailsSummary.
        The `OCID`__ of the DBRS policy used for backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbrs_policy_id of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._dbrs_policy_id

    @dbrs_policy_id.setter
    def dbrs_policy_id(self, dbrs_policy_id):
        """
        Sets the dbrs_policy_id of this BackupDestinationDetailsSummary.
        The `OCID`__ of the DBRS policy used for backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbrs_policy_id: The dbrs_policy_id of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._dbrs_policy_id = dbrs_policy_id

    @property
    def is_retention_lock_enabled(self):
        """
        Gets the is_retention_lock_enabled of this BackupDestinationDetailsSummary.
        Indicates if backup retention is locked for all the database backups in the Autonomous Container Database (ACD). The retention window cannot be decreased if the backup retention lock is enabled.
        Once applied on the Autonomous Container Database, the retention lock cannot be removed, or the retention period cannot be decreased after a 14-day period.
        If the backup is a Long Term Backup and retention lock is enabled, the backup cannot be deleted and must expire.
        The retention lock set on the Autonomous Container Database is not applicable for cross region remote backups and backups hosted on recovery Appliance backup destination.


        :return: The is_retention_lock_enabled of this BackupDestinationDetailsSummary.
        :rtype: bool
        """
        return self._is_retention_lock_enabled

    @is_retention_lock_enabled.setter
    def is_retention_lock_enabled(self, is_retention_lock_enabled):
        """
        Sets the is_retention_lock_enabled of this BackupDestinationDetailsSummary.
        Indicates if backup retention is locked for all the database backups in the Autonomous Container Database (ACD). The retention window cannot be decreased if the backup retention lock is enabled.
        Once applied on the Autonomous Container Database, the retention lock cannot be removed, or the retention period cannot be decreased after a 14-day period.
        If the backup is a Long Term Backup and retention lock is enabled, the backup cannot be deleted and must expire.
        The retention lock set on the Autonomous Container Database is not applicable for cross region remote backups and backups hosted on recovery Appliance backup destination.


        :param is_retention_lock_enabled: The is_retention_lock_enabled of this BackupDestinationDetailsSummary.
        :type: bool
        """
        self._is_retention_lock_enabled = is_retention_lock_enabled

    @property
    def backup_retention_policy_on_terminate(self):
        """
        Gets the backup_retention_policy_on_terminate of this BackupDestinationDetailsSummary.
        Defines the automatic and manual backup retention policy for the Autonomous AI Database termination.
        The retention policy set on the Autonomous Container Database is not applicable for cross region remote backups and backups hosted on recovery Appliance backup destination.
        Options are 'RETAIN_PER_RETENTION_WINDOW' or 'RETAIN_FOR_72_HOURS'.The default value is 'RETAIN_FOR_72_HOURS'.

        Allowed values for this property are: "RETAIN_PER_RETENTION_WINDOW", "RETAIN_FOR_72_HOURS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The backup_retention_policy_on_terminate of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._backup_retention_policy_on_terminate

    @backup_retention_policy_on_terminate.setter
    def backup_retention_policy_on_terminate(self, backup_retention_policy_on_terminate):
        """
        Sets the backup_retention_policy_on_terminate of this BackupDestinationDetailsSummary.
        Defines the automatic and manual backup retention policy for the Autonomous AI Database termination.
        The retention policy set on the Autonomous Container Database is not applicable for cross region remote backups and backups hosted on recovery Appliance backup destination.
        Options are 'RETAIN_PER_RETENTION_WINDOW' or 'RETAIN_FOR_72_HOURS'.The default value is 'RETAIN_FOR_72_HOURS'.


        :param backup_retention_policy_on_terminate: The backup_retention_policy_on_terminate of this BackupDestinationDetailsSummary.
        :type: str
        """
        allowed_values = ["RETAIN_PER_RETENTION_WINDOW", "RETAIN_FOR_72_HOURS"]
        if not value_allowed_none_or_none_sentinel(backup_retention_policy_on_terminate, allowed_values):
            backup_retention_policy_on_terminate = 'UNKNOWN_ENUM_VALUE'
        self._backup_retention_policy_on_terminate = backup_retention_policy_on_terminate

    @property
    def is_remote(self):
        """
        Gets the is_remote of this BackupDestinationDetailsSummary.
        Indicates whether the backup destination is cross-region or local.


        :return: The is_remote of this BackupDestinationDetailsSummary.
        :rtype: bool
        """
        return self._is_remote

    @is_remote.setter
    def is_remote(self, is_remote):
        """
        Sets the is_remote of this BackupDestinationDetailsSummary.
        Indicates whether the backup destination is cross-region or local.


        :param is_remote: The is_remote of this BackupDestinationDetailsSummary.
        :type: bool
        """
        self._is_remote = is_remote

    @property
    def remote_region(self):
        """
        Gets the remote_region of this BackupDestinationDetailsSummary.
        The name of the remote region where the remote automatic incremental backups will be stored.
        For information about valid region names, see
        `Regions and Availability Domains`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/regions.htm


        :return: The remote_region of this BackupDestinationDetailsSummary.
        :rtype: str
        """
        return self._remote_region

    @remote_region.setter
    def remote_region(self, remote_region):
        """
        Sets the remote_region of this BackupDestinationDetailsSummary.
        The name of the remote region where the remote automatic incremental backups will be stored.
        For information about valid region names, see
        `Regions and Availability Domains`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/regions.htm


        :param remote_region: The remote_region of this BackupDestinationDetailsSummary.
        :type: str
        """
        self._remote_region = remote_region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
