# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlQuerySampleDetails(object):
    """
    The details of a query sample including the query text, execution time and other details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlQuerySampleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param query_sample_text:
            The value to assign to the query_sample_text property of this MySqlQuerySampleDetails.
        :type query_sample_text: str

        :param time_query_sample_seen:
            The value to assign to the time_query_sample_seen property of this MySqlQuerySampleDetails.
        :type time_query_sample_seen: datetime

        :param execution_time:
            The value to assign to the execution_time property of this MySqlQuerySampleDetails.
        :type execution_time: int

        :param thread_id:
            The value to assign to the thread_id property of this MySqlQuerySampleDetails.
        :type thread_id: int

        :param user:
            The value to assign to the user property of this MySqlQuerySampleDetails.
        :type user: str

        :param host:
            The value to assign to the host property of this MySqlQuerySampleDetails.
        :type host: str

        :param mysql_instance:
            The value to assign to the mysql_instance property of this MySqlQuerySampleDetails.
        :type mysql_instance: str

        """
        self.swagger_types = {
            'query_sample_text': 'str',
            'time_query_sample_seen': 'datetime',
            'execution_time': 'int',
            'thread_id': 'int',
            'user': 'str',
            'host': 'str',
            'mysql_instance': 'str'
        }
        self.attribute_map = {
            'query_sample_text': 'querySampleText',
            'time_query_sample_seen': 'timeQuerySampleSeen',
            'execution_time': 'executionTime',
            'thread_id': 'threadId',
            'user': 'user',
            'host': 'host',
            'mysql_instance': 'mysqlInstance'
        }
        self._query_sample_text = None
        self._time_query_sample_seen = None
        self._execution_time = None
        self._thread_id = None
        self._user = None
        self._host = None
        self._mysql_instance = None

    @property
    def query_sample_text(self):
        """
        **[Required]** Gets the query_sample_text of this MySqlQuerySampleDetails.
        The query sample mapped by MySQL to a given normalized query.


        :return: The query_sample_text of this MySqlQuerySampleDetails.
        :rtype: str
        """
        return self._query_sample_text

    @query_sample_text.setter
    def query_sample_text(self, query_sample_text):
        """
        Sets the query_sample_text of this MySqlQuerySampleDetails.
        The query sample mapped by MySQL to a given normalized query.


        :param query_sample_text: The query_sample_text of this MySqlQuerySampleDetails.
        :type: str
        """
        self._query_sample_text = query_sample_text

    @property
    def time_query_sample_seen(self):
        """
        **[Required]** Gets the time_query_sample_seen of this MySqlQuerySampleDetails.
        The date and time the query sample was last seen.


        :return: The time_query_sample_seen of this MySqlQuerySampleDetails.
        :rtype: datetime
        """
        return self._time_query_sample_seen

    @time_query_sample_seen.setter
    def time_query_sample_seen(self, time_query_sample_seen):
        """
        Sets the time_query_sample_seen of this MySqlQuerySampleDetails.
        The date and time the query sample was last seen.


        :param time_query_sample_seen: The time_query_sample_seen of this MySqlQuerySampleDetails.
        :type: datetime
        """
        self._time_query_sample_seen = time_query_sample_seen

    @property
    def execution_time(self):
        """
        **[Required]** Gets the execution_time of this MySqlQuerySampleDetails.
        The total amount of time that has been spent executing the query sample.


        :return: The execution_time of this MySqlQuerySampleDetails.
        :rtype: int
        """
        return self._execution_time

    @execution_time.setter
    def execution_time(self, execution_time):
        """
        Sets the execution_time of this MySqlQuerySampleDetails.
        The total amount of time that has been spent executing the query sample.


        :param execution_time: The execution_time of this MySqlQuerySampleDetails.
        :type: int
        """
        self._execution_time = execution_time

    @property
    def thread_id(self):
        """
        **[Required]** Gets the thread_id of this MySqlQuerySampleDetails.
        The thread id of the connection.


        :return: The thread_id of this MySqlQuerySampleDetails.
        :rtype: int
        """
        return self._thread_id

    @thread_id.setter
    def thread_id(self, thread_id):
        """
        Sets the thread_id of this MySqlQuerySampleDetails.
        The thread id of the connection.


        :param thread_id: The thread_id of this MySqlQuerySampleDetails.
        :type: int
        """
        self._thread_id = thread_id

    @property
    def user(self):
        """
        **[Required]** Gets the user of this MySqlQuerySampleDetails.
        The user who ran the query sample.


        :return: The user of this MySqlQuerySampleDetails.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this MySqlQuerySampleDetails.
        The user who ran the query sample.


        :param user: The user of this MySqlQuerySampleDetails.
        :type: str
        """
        self._user = user

    @property
    def host(self):
        """
        **[Required]** Gets the host of this MySqlQuerySampleDetails.
        The host from which the query sample was run.


        :return: The host of this MySqlQuerySampleDetails.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this MySqlQuerySampleDetails.
        The host from which the query sample was run.


        :param host: The host of this MySqlQuerySampleDetails.
        :type: str
        """
        self._host = host

    @property
    def mysql_instance(self):
        """
        **[Required]** Gets the mysql_instance of this MySqlQuerySampleDetails.
        The MySQL instance against which the query sample was run.


        :return: The mysql_instance of this MySqlQuerySampleDetails.
        :rtype: str
        """
        return self._mysql_instance

    @mysql_instance.setter
    def mysql_instance(self, mysql_instance):
        """
        Sets the mysql_instance of this MySqlQuerySampleDetails.
        The MySQL instance against which the query sample was run.


        :param mysql_instance: The mysql_instance of this MySqlQuerySampleDetails.
        :type: str
        """
        self._mysql_instance = mysql_instance

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
