# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StandByDatabaseDataguardMetrics(object):
    """
    The standby database details.
    """

    #: A constant which can be used with the db_role property of a StandByDatabaseDataguardMetrics.
    #: This constant has a value of "SNAPSHOT_STANDBY"
    DB_ROLE_SNAPSHOT_STANDBY = "SNAPSHOT_STANDBY"

    #: A constant which can be used with the db_role property of a StandByDatabaseDataguardMetrics.
    #: This constant has a value of "LOGICAL_STANDBY"
    DB_ROLE_LOGICAL_STANDBY = "LOGICAL_STANDBY"

    #: A constant which can be used with the db_role property of a StandByDatabaseDataguardMetrics.
    #: This constant has a value of "PHYSICAL_STANDBY"
    DB_ROLE_PHYSICAL_STANDBY = "PHYSICAL_STANDBY"

    #: A constant which can be used with the db_role property of a StandByDatabaseDataguardMetrics.
    #: This constant has a value of "PRIMARY"
    DB_ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the db_role property of a StandByDatabaseDataguardMetrics.
    #: This constant has a value of "FAR_SYNC"
    DB_ROLE_FAR_SYNC = "FAR_SYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new StandByDatabaseDataguardMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_id:
            The value to assign to the db_id property of this StandByDatabaseDataguardMetrics.
        :type db_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this StandByDatabaseDataguardMetrics.
        :type compartment_id: str

        :param database_id:
            The value to assign to the database_id property of this StandByDatabaseDataguardMetrics.
        :type database_id: str

        :param database_name:
            The value to assign to the database_name property of this StandByDatabaseDataguardMetrics.
        :type database_name: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this StandByDatabaseDataguardMetrics.
        :type db_unique_name: str

        :param db_role:
            The value to assign to the db_role property of this StandByDatabaseDataguardMetrics.
            Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_role: str

        :param metrics:
            The value to assign to the metrics property of this StandByDatabaseDataguardMetrics.
        :type metrics: list[oci.database_management.models.HaMetricDefinition]

        """
        self.swagger_types = {
            'db_id': 'str',
            'compartment_id': 'str',
            'database_id': 'str',
            'database_name': 'str',
            'db_unique_name': 'str',
            'db_role': 'str',
            'metrics': 'list[HaMetricDefinition]'
        }
        self.attribute_map = {
            'db_id': 'dbId',
            'compartment_id': 'compartmentId',
            'database_id': 'databaseId',
            'database_name': 'databaseName',
            'db_unique_name': 'dbUniqueName',
            'db_role': 'dbRole',
            'metrics': 'metrics'
        }
        self._db_id = None
        self._compartment_id = None
        self._database_id = None
        self._database_name = None
        self._db_unique_name = None
        self._db_role = None
        self._metrics = None

    @property
    def db_id(self):
        """
        **[Required]** Gets the db_id of this StandByDatabaseDataguardMetrics.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_id of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._db_id

    @db_id.setter
    def db_id(self, db_id):
        """
        Sets the db_id of this StandByDatabaseDataguardMetrics.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_id: The db_id of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        self._db_id = db_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this StandByDatabaseDataguardMetrics.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this StandByDatabaseDataguardMetrics.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def database_id(self):
        """
        Gets the database_id of this StandByDatabaseDataguardMetrics.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :return: The database_id of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this StandByDatabaseDataguardMetrics.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :param database_id: The database_id of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        self._database_id = database_id

    @property
    def database_name(self):
        """
        **[Required]** Gets the database_name of this StandByDatabaseDataguardMetrics.
        The display name of the Managed Database.


        :return: The database_name of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this StandByDatabaseDataguardMetrics.
        The display name of the Managed Database.


        :param database_name: The database_name of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        self._database_name = database_name

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this StandByDatabaseDataguardMetrics.
        The database unique name of the Managed Database.


        :return: The db_unique_name of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this StandByDatabaseDataguardMetrics.
        The database unique name of the Managed Database.


        :param db_unique_name: The db_unique_name of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def db_role(self):
        """
        **[Required]** Gets the db_role of this StandByDatabaseDataguardMetrics.
        The database role of the Managed Database.

        Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_role of this StandByDatabaseDataguardMetrics.
        :rtype: str
        """
        return self._db_role

    @db_role.setter
    def db_role(self, db_role):
        """
        Sets the db_role of this StandByDatabaseDataguardMetrics.
        The database role of the Managed Database.


        :param db_role: The db_role of this StandByDatabaseDataguardMetrics.
        :type: str
        """
        allowed_values = ["SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC"]
        if not value_allowed_none_or_none_sentinel(db_role, allowed_values):
            db_role = 'UNKNOWN_ENUM_VALUE'
        self._db_role = db_role

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this StandByDatabaseDataguardMetrics.
        A list of standby databases with latest values for metrics such as ApplyLag, TransportLag, and RedoApplyRate.


        :return: The metrics of this StandByDatabaseDataguardMetrics.
        :rtype: list[oci.database_management.models.HaMetricDefinition]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this StandByDatabaseDataguardMetrics.
        A list of standby databases with latest values for metrics such as ApplyLag, TransportLag, and RedoApplyRate.


        :param metrics: The metrics of this StandByDatabaseDataguardMetrics.
        :type: list[oci.database_management.models.HaMetricDefinition]
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
