# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MigrationParameterSummary(object):
    """
    Migration parameter response object.
    """

    #: A constant which can be used with the database_combination property of a MigrationParameterSummary.
    #: This constant has a value of "MYSQL"
    DATABASE_COMBINATION_MYSQL = "MYSQL"

    #: A constant which can be used with the database_combination property of a MigrationParameterSummary.
    #: This constant has a value of "ORACLE"
    DATABASE_COMBINATION_ORACLE = "ORACLE"

    #: A constant which can be used with the migration_type property of a MigrationParameterSummary.
    #: This constant has a value of "ONLINE"
    MIGRATION_TYPE_ONLINE = "ONLINE"

    #: A constant which can be used with the migration_type property of a MigrationParameterSummary.
    #: This constant has a value of "OFFLINE"
    MIGRATION_TYPE_OFFLINE = "OFFLINE"

    #: A constant which can be used with the data_type property of a MigrationParameterSummary.
    #: This constant has a value of "STRING"
    DATA_TYPE_STRING = "STRING"

    #: A constant which can be used with the data_type property of a MigrationParameterSummary.
    #: This constant has a value of "INTEGER"
    DATA_TYPE_INTEGER = "INTEGER"

    #: A constant which can be used with the data_type property of a MigrationParameterSummary.
    #: This constant has a value of "FLOAT"
    DATA_TYPE_FLOAT = "FLOAT"

    #: A constant which can be used with the data_type property of a MigrationParameterSummary.
    #: This constant has a value of "BOOLEAN"
    DATA_TYPE_BOOLEAN = "BOOLEAN"

    def __init__(self, **kwargs):
        """
        Initializes a new MigrationParameterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this MigrationParameterSummary.
            Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this MigrationParameterSummary.
        :type display_name: str

        :param doc_url_link:
            The value to assign to the doc_url_link property of this MigrationParameterSummary.
        :type doc_url_link: str

        :param description:
            The value to assign to the description property of this MigrationParameterSummary.
        :type description: str

        :param category_name:
            The value to assign to the category_name property of this MigrationParameterSummary.
        :type category_name: str

        :param category_display_name:
            The value to assign to the category_display_name property of this MigrationParameterSummary.
        :type category_display_name: str

        :param migration_type:
            The value to assign to the migration_type property of this MigrationParameterSummary.
            Allowed values for this property are: "ONLINE", "OFFLINE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type migration_type: str

        :param default_value:
            The value to assign to the default_value property of this MigrationParameterSummary.
        :type default_value: str

        :param min_value:
            The value to assign to the min_value property of this MigrationParameterSummary.
        :type min_value: float

        :param max_value:
            The value to assign to the max_value property of this MigrationParameterSummary.
        :type max_value: float

        :param hint_text:
            The value to assign to the hint_text property of this MigrationParameterSummary.
        :type hint_text: str

        :param name:
            The value to assign to the name property of this MigrationParameterSummary.
        :type name: str

        :param data_type:
            The value to assign to the data_type property of this MigrationParameterSummary.
            Allowed values for this property are: "STRING", "INTEGER", "FLOAT", "BOOLEAN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type data_type: str

        """
        self.swagger_types = {
            'database_combination': 'str',
            'display_name': 'str',
            'doc_url_link': 'str',
            'description': 'str',
            'category_name': 'str',
            'category_display_name': 'str',
            'migration_type': 'str',
            'default_value': 'str',
            'min_value': 'float',
            'max_value': 'float',
            'hint_text': 'str',
            'name': 'str',
            'data_type': 'str'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'doc_url_link': 'docUrlLink',
            'description': 'description',
            'category_name': 'categoryName',
            'category_display_name': 'categoryDisplayName',
            'migration_type': 'migrationType',
            'default_value': 'defaultValue',
            'min_value': 'minValue',
            'max_value': 'maxValue',
            'hint_text': 'hintText',
            'name': 'name',
            'data_type': 'dataType'
        }
        self._database_combination = None
        self._display_name = None
        self._doc_url_link = None
        self._description = None
        self._category_name = None
        self._category_display_name = None
        self._migration_type = None
        self._default_value = None
        self._min_value = None
        self._max_value = None
        self._hint_text = None
        self._name = None
        self._data_type = None

    @property
    def database_combination(self):
        """
        **[Required]** Gets the database_combination of this MigrationParameterSummary.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.

        Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_combination of this MigrationParameterSummary.
        :rtype: str
        """
        return self._database_combination

    @database_combination.setter
    def database_combination(self, database_combination):
        """
        Sets the database_combination of this MigrationParameterSummary.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.


        :param database_combination: The database_combination of this MigrationParameterSummary.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(database_combination, allowed_values):
            database_combination = 'UNKNOWN_ENUM_VALUE'
        self._database_combination = database_combination

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this MigrationParameterSummary.
        Parameter display name.


        :return: The display_name of this MigrationParameterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MigrationParameterSummary.
        Parameter display name.


        :param display_name: The display_name of this MigrationParameterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def doc_url_link(self):
        """
        Gets the doc_url_link of this MigrationParameterSummary.
        Parameter documentation URL link.


        :return: The doc_url_link of this MigrationParameterSummary.
        :rtype: str
        """
        return self._doc_url_link

    @doc_url_link.setter
    def doc_url_link(self, doc_url_link):
        """
        Sets the doc_url_link of this MigrationParameterSummary.
        Parameter documentation URL link.


        :param doc_url_link: The doc_url_link of this MigrationParameterSummary.
        :type: str
        """
        self._doc_url_link = doc_url_link

    @property
    def description(self):
        """
        **[Required]** Gets the description of this MigrationParameterSummary.
        Parameter name description.


        :return: The description of this MigrationParameterSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MigrationParameterSummary.
        Parameter name description.


        :param description: The description of this MigrationParameterSummary.
        :type: str
        """
        self._description = description

    @property
    def category_name(self):
        """
        **[Required]** Gets the category_name of this MigrationParameterSummary.
        Parameter category name.


        :return: The category_name of this MigrationParameterSummary.
        :rtype: str
        """
        return self._category_name

    @category_name.setter
    def category_name(self, category_name):
        """
        Sets the category_name of this MigrationParameterSummary.
        Parameter category name.


        :param category_name: The category_name of this MigrationParameterSummary.
        :type: str
        """
        self._category_name = category_name

    @property
    def category_display_name(self):
        """
        **[Required]** Gets the category_display_name of this MigrationParameterSummary.
        Parameter category display name.


        :return: The category_display_name of this MigrationParameterSummary.
        :rtype: str
        """
        return self._category_display_name

    @category_display_name.setter
    def category_display_name(self, category_display_name):
        """
        Sets the category_display_name of this MigrationParameterSummary.
        Parameter category display name.


        :param category_display_name: The category_display_name of this MigrationParameterSummary.
        :type: str
        """
        self._category_display_name = category_display_name

    @property
    def migration_type(self):
        """
        **[Required]** Gets the migration_type of this MigrationParameterSummary.
        Migration Stage.

        Allowed values for this property are: "ONLINE", "OFFLINE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The migration_type of this MigrationParameterSummary.
        :rtype: str
        """
        return self._migration_type

    @migration_type.setter
    def migration_type(self, migration_type):
        """
        Sets the migration_type of this MigrationParameterSummary.
        Migration Stage.


        :param migration_type: The migration_type of this MigrationParameterSummary.
        :type: str
        """
        allowed_values = ["ONLINE", "OFFLINE"]
        if not value_allowed_none_or_none_sentinel(migration_type, allowed_values):
            migration_type = 'UNKNOWN_ENUM_VALUE'
        self._migration_type = migration_type

    @property
    def default_value(self):
        """
        Gets the default_value of this MigrationParameterSummary.
        Default value for a parameter.


        :return: The default_value of this MigrationParameterSummary.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this MigrationParameterSummary.
        Default value for a parameter.


        :param default_value: The default_value of this MigrationParameterSummary.
        :type: str
        """
        self._default_value = default_value

    @property
    def min_value(self):
        """
        Gets the min_value of this MigrationParameterSummary.
        Parameter minimum value.


        :return: The min_value of this MigrationParameterSummary.
        :rtype: float
        """
        return self._min_value

    @min_value.setter
    def min_value(self, min_value):
        """
        Sets the min_value of this MigrationParameterSummary.
        Parameter minimum value.


        :param min_value: The min_value of this MigrationParameterSummary.
        :type: float
        """
        self._min_value = min_value

    @property
    def max_value(self):
        """
        Gets the max_value of this MigrationParameterSummary.
        Parameter maximum value.


        :return: The max_value of this MigrationParameterSummary.
        :rtype: float
        """
        return self._max_value

    @max_value.setter
    def max_value(self, max_value):
        """
        Sets the max_value of this MigrationParameterSummary.
        Parameter maximum value.


        :param max_value: The max_value of this MigrationParameterSummary.
        :type: float
        """
        self._max_value = max_value

    @property
    def hint_text(self):
        """
        Gets the hint_text of this MigrationParameterSummary.
        Hint text for parameter value.


        :return: The hint_text of this MigrationParameterSummary.
        :rtype: str
        """
        return self._hint_text

    @hint_text.setter
    def hint_text(self, hint_text):
        """
        Sets the hint_text of this MigrationParameterSummary.
        Hint text for parameter value.


        :param hint_text: The hint_text of this MigrationParameterSummary.
        :type: str
        """
        self._hint_text = hint_text

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MigrationParameterSummary.
        Parameter name.


        :return: The name of this MigrationParameterSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MigrationParameterSummary.
        Parameter name.


        :param name: The name of this MigrationParameterSummary.
        :type: str
        """
        self._name = name

    @property
    def data_type(self):
        """
        **[Required]** Gets the data_type of this MigrationParameterSummary.
        Parameter data type.

        Allowed values for this property are: "STRING", "INTEGER", "FLOAT", "BOOLEAN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The data_type of this MigrationParameterSummary.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this MigrationParameterSummary.
        Parameter data type.


        :param data_type: The data_type of this MigrationParameterSummary.
        :type: str
        """
        allowed_values = ["STRING", "INTEGER", "FLOAT", "BOOLEAN"]
        if not value_allowed_none_or_none_sentinel(data_type, allowed_values):
            data_type = 'UNKNOWN_ENUM_VALUE'
        self._data_type = data_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
