# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchComplianceDetails(object):
    """
    Patch Compliance Status
    """

    #: A constant which can be used with the patch_compliance_status property of a PatchComplianceDetails.
    #: This constant has a value of "GREEN"
    PATCH_COMPLIANCE_STATUS_GREEN = "GREEN"

    #: A constant which can be used with the patch_compliance_status property of a PatchComplianceDetails.
    #: This constant has a value of "YELLOW"
    PATCH_COMPLIANCE_STATUS_YELLOW = "YELLOW"

    #: A constant which can be used with the patch_compliance_status property of a PatchComplianceDetails.
    #: This constant has a value of "RED"
    PATCH_COMPLIANCE_STATUS_RED = "RED"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchComplianceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patch_compliance_status:
            The value to assign to the patch_compliance_status property of this PatchComplianceDetails.
            Allowed values for this property are: "GREEN", "YELLOW", "RED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type patch_compliance_status: str

        :param patch_compliance_version:
            The value to assign to the patch_compliance_version property of this PatchComplianceDetails.
        :type patch_compliance_version: str

        """
        self.swagger_types = {
            'patch_compliance_status': 'str',
            'patch_compliance_version': 'str'
        }
        self.attribute_map = {
            'patch_compliance_status': 'patchComplianceStatus',
            'patch_compliance_version': 'patchComplianceVersion'
        }
        self._patch_compliance_status = None
        self._patch_compliance_version = None

    @property
    def patch_compliance_status(self):
        """
        Gets the patch_compliance_status of this PatchComplianceDetails.
        Patch compliance status.

        Allowed values for this property are: "GREEN", "YELLOW", "RED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The patch_compliance_status of this PatchComplianceDetails.
        :rtype: str
        """
        return self._patch_compliance_status

    @patch_compliance_status.setter
    def patch_compliance_status(self, patch_compliance_status):
        """
        Sets the patch_compliance_status of this PatchComplianceDetails.
        Patch compliance status.


        :param patch_compliance_status: The patch_compliance_status of this PatchComplianceDetails.
        :type: str
        """
        allowed_values = ["GREEN", "YELLOW", "RED"]
        if not value_allowed_none_or_none_sentinel(patch_compliance_status, allowed_values):
            patch_compliance_status = 'UNKNOWN_ENUM_VALUE'
        self._patch_compliance_status = patch_compliance_status

    @property
    def patch_compliance_version(self):
        """
        Gets the patch_compliance_version of this PatchComplianceDetails.
        Resource patch compliance version name.


        :return: The patch_compliance_version of this PatchComplianceDetails.
        :rtype: str
        """
        return self._patch_compliance_version

    @patch_compliance_version.setter
    def patch_compliance_version(self, patch_compliance_version):
        """
        Sets the patch_compliance_version of this PatchComplianceDetails.
        Resource patch compliance version name.


        :param patch_compliance_version: The patch_compliance_version of this PatchComplianceDetails.
        :type: str
        """
        self._patch_compliance_version = patch_compliance_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
