# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .merge_check import MergeCheck
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApprovalRuleMergeCheck(MergeCheck):
    """
    The status of the approval rules.
    """

    #: A constant which can be used with the status property of a ApprovalRuleMergeCheck.
    #: This constant has a value of "NEEDS_APPROVAL"
    STATUS_NEEDS_APPROVAL = "NEEDS_APPROVAL"

    #: A constant which can be used with the status property of a ApprovalRuleMergeCheck.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the level property of a ApprovalRuleMergeCheck.
    #: This constant has a value of "PROJECT"
    LEVEL_PROJECT = "PROJECT"

    #: A constant which can be used with the level property of a ApprovalRuleMergeCheck.
    #: This constant has a value of "REPOSITORY"
    LEVEL_REPOSITORY = "REPOSITORY"

    def __init__(self, **kwargs):
        """
        Initializes a new ApprovalRuleMergeCheck object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.ApprovalRuleMergeCheck.type` attribute
        of this class is ``APPROVAL_RULE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ApprovalRuleMergeCheck.
            Allowed values for this property are: "CONFLICT", "APPROVAL_RULE", "BUILD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param rule_name:
            The value to assign to the rule_name property of this ApprovalRuleMergeCheck.
        :type rule_name: str

        :param status:
            The value to assign to the status property of this ApprovalRuleMergeCheck.
            Allowed values for this property are: "NEEDS_APPROVAL", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param total_approval_count:
            The value to assign to the total_approval_count property of this ApprovalRuleMergeCheck.
        :type total_approval_count: int

        :param current_approval_count:
            The value to assign to the current_approval_count property of this ApprovalRuleMergeCheck.
        :type current_approval_count: int

        :param reviewers:
            The value to assign to the reviewers property of this ApprovalRuleMergeCheck.
        :type reviewers: list[oci.devops.models.PrincipalDetails]

        :param level:
            The value to assign to the level property of this ApprovalRuleMergeCheck.
            Allowed values for this property are: "PROJECT", "REPOSITORY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type level: str

        """
        self.swagger_types = {
            'type': 'str',
            'rule_name': 'str',
            'status': 'str',
            'total_approval_count': 'int',
            'current_approval_count': 'int',
            'reviewers': 'list[PrincipalDetails]',
            'level': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'rule_name': 'ruleName',
            'status': 'status',
            'total_approval_count': 'totalApprovalCount',
            'current_approval_count': 'currentApprovalCount',
            'reviewers': 'reviewers',
            'level': 'level'
        }
        self._type = None
        self._rule_name = None
        self._status = None
        self._total_approval_count = None
        self._current_approval_count = None
        self._reviewers = None
        self._level = None
        self._type = 'APPROVAL_RULE'

    @property
    def rule_name(self):
        """
        Gets the rule_name of this ApprovalRuleMergeCheck.
        The name of the rule.


        :return: The rule_name of this ApprovalRuleMergeCheck.
        :rtype: str
        """
        return self._rule_name

    @rule_name.setter
    def rule_name(self, rule_name):
        """
        Sets the rule_name of this ApprovalRuleMergeCheck.
        The name of the rule.


        :param rule_name: The rule_name of this ApprovalRuleMergeCheck.
        :type: str
        """
        self._rule_name = rule_name

    @property
    def status(self):
        """
        Gets the status of this ApprovalRuleMergeCheck.
        The status of the approval rule.

        Allowed values for this property are: "NEEDS_APPROVAL", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ApprovalRuleMergeCheck.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ApprovalRuleMergeCheck.
        The status of the approval rule.


        :param status: The status of this ApprovalRuleMergeCheck.
        :type: str
        """
        allowed_values = ["NEEDS_APPROVAL", "SUCCEEDED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def total_approval_count(self):
        """
        Gets the total_approval_count of this ApprovalRuleMergeCheck.
        The number of total approvals needed.


        :return: The total_approval_count of this ApprovalRuleMergeCheck.
        :rtype: int
        """
        return self._total_approval_count

    @total_approval_count.setter
    def total_approval_count(self, total_approval_count):
        """
        Sets the total_approval_count of this ApprovalRuleMergeCheck.
        The number of total approvals needed.


        :param total_approval_count: The total_approval_count of this ApprovalRuleMergeCheck.
        :type: int
        """
        self._total_approval_count = total_approval_count

    @property
    def current_approval_count(self):
        """
        Gets the current_approval_count of this ApprovalRuleMergeCheck.
        The current number of approvals.


        :return: The current_approval_count of this ApprovalRuleMergeCheck.
        :rtype: int
        """
        return self._current_approval_count

    @current_approval_count.setter
    def current_approval_count(self, current_approval_count):
        """
        Sets the current_approval_count of this ApprovalRuleMergeCheck.
        The current number of approvals.


        :param current_approval_count: The current_approval_count of this ApprovalRuleMergeCheck.
        :type: int
        """
        self._current_approval_count = current_approval_count

    @property
    def reviewers(self):
        """
        Gets the reviewers of this ApprovalRuleMergeCheck.
        The list of default reviewers.


        :return: The reviewers of this ApprovalRuleMergeCheck.
        :rtype: list[oci.devops.models.PrincipalDetails]
        """
        return self._reviewers

    @reviewers.setter
    def reviewers(self, reviewers):
        """
        Sets the reviewers of this ApprovalRuleMergeCheck.
        The list of default reviewers.


        :param reviewers: The reviewers of this ApprovalRuleMergeCheck.
        :type: list[oci.devops.models.PrincipalDetails]
        """
        self._reviewers = reviewers

    @property
    def level(self):
        """
        Gets the level of this ApprovalRuleMergeCheck.
        The level of rule.

        Allowed values for this property are: "PROJECT", "REPOSITORY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The level of this ApprovalRuleMergeCheck.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this ApprovalRuleMergeCheck.
        The level of rule.


        :param level: The level of this ApprovalRuleMergeCheck.
        :type: str
        """
        allowed_values = ["PROJECT", "REPOSITORY"]
        if not value_allowed_none_or_none_sentinel(level, allowed_values):
            level = 'UNKNOWN_ENUM_VALUE'
        self._level = level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
