# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .merge_pull_request_details import MergePullRequestDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateMergePullRequestDetails(MergePullRequestDetails):
    """
    The information about the merge validation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateMergePullRequestDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.ValidateMergePullRequestDetails.action_type` attribute
        of this class is ``VALIDATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this ValidateMergePullRequestDetails.
            Allowed values for this property are: "EXECUTE", "VALIDATE"
        :type action_type: str

        """
        self.swagger_types = {
            'action_type': 'str'
        }
        self.attribute_map = {
            'action_type': 'actionType'
        }
        self._action_type = None
        self._action_type = 'VALIDATE'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
