# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageUpdateDetail(object):
    """
    Details of Object Storage instance to be updated.
    """

    #: A constant which can be used with the object_versioning property of a ObjectStorageUpdateDetail.
    #: This constant has a value of "ENABLED"
    OBJECT_VERSIONING_ENABLED = "ENABLED"

    #: A constant which can be used with the object_versioning property of a ObjectStorageUpdateDetail.
    #: This constant has a value of "SUSPENDED"
    OBJECT_VERSIONING_SUSPENDED = "SUSPENDED"

    #: A constant which can be used with the object_versioning property of a ObjectStorageUpdateDetail.
    #: This constant has a value of "DISABLED"
    OBJECT_VERSIONING_DISABLED = "DISABLED"

    #: A constant which can be used with the auto_tiering property of a ObjectStorageUpdateDetail.
    #: This constant has a value of "DISABLED"
    AUTO_TIERING_DISABLED = "DISABLED"

    #: A constant which can be used with the auto_tiering property of a ObjectStorageUpdateDetail.
    #: This constant has a value of "INFREQUENTACCESS"
    AUTO_TIERING_INFREQUENTACCESS = "INFREQUENTACCESS"

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageUpdateDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this ObjectStorageUpdateDetail.
        :type instance_id: str

        :param object_versioning:
            The value to assign to the object_versioning property of this ObjectStorageUpdateDetail.
            Allowed values for this property are: "ENABLED", "SUSPENDED", "DISABLED"
        :type object_versioning: str

        :param auto_tiering:
            The value to assign to the auto_tiering property of this ObjectStorageUpdateDetail.
            Allowed values for this property are: "DISABLED", "INFREQUENTACCESS"
        :type auto_tiering: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'object_versioning': 'str',
            'auto_tiering': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'object_versioning': 'objectVersioning',
            'auto_tiering': 'autoTiering'
        }
        self._instance_id = None
        self._object_versioning = None
        self._auto_tiering = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this ObjectStorageUpdateDetail.
        Instance id of the existing Object Storage instance to be updated.


        :return: The instance_id of this ObjectStorageUpdateDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ObjectStorageUpdateDetail.
        Instance id of the existing Object Storage instance to be updated.


        :param instance_id: The instance_id of this ObjectStorageUpdateDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def object_versioning(self):
        """
        Gets the object_versioning of this ObjectStorageUpdateDetail.
        Mentions which storage tier to use for the bucket,Allowed values are \"STANDARD\" / \"ARCHIVE\"

        Allowed values for this property are: "ENABLED", "SUSPENDED", "DISABLED"


        :return: The object_versioning of this ObjectStorageUpdateDetail.
        :rtype: str
        """
        return self._object_versioning

    @object_versioning.setter
    def object_versioning(self, object_versioning):
        """
        Sets the object_versioning of this ObjectStorageUpdateDetail.
        Mentions which storage tier to use for the bucket,Allowed values are \"STANDARD\" / \"ARCHIVE\"


        :param object_versioning: The object_versioning of this ObjectStorageUpdateDetail.
        :type: str
        """
        allowed_values = ["ENABLED", "SUSPENDED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(object_versioning, allowed_values):
            raise ValueError(
                f"Invalid value for `object_versioning`, must be None or one of {allowed_values}"
            )
        self._object_versioning = object_versioning

    @property
    def auto_tiering(self):
        """
        Gets the auto_tiering of this ObjectStorageUpdateDetail.
        It sets the auto-tiering status on the bucket.Allowed values are \"DISABLED\" / \"INFREQUENTACCESS\"

        Allowed values for this property are: "DISABLED", "INFREQUENTACCESS"


        :return: The auto_tiering of this ObjectStorageUpdateDetail.
        :rtype: str
        """
        return self._auto_tiering

    @auto_tiering.setter
    def auto_tiering(self, auto_tiering):
        """
        Sets the auto_tiering of this ObjectStorageUpdateDetail.
        It sets the auto-tiering status on the bucket.Allowed values are \"DISABLED\" / \"INFREQUENTACCESS\"


        :param auto_tiering: The auto_tiering of this ObjectStorageUpdateDetail.
        :type: str
        """
        allowed_values = ["DISABLED", "INFREQUENTACCESS"]
        if not value_allowed_none_or_none_sentinel(auto_tiering, allowed_values):
            raise ValueError(
                f"Invalid value for `auto_tiering`, must be None or one of {allowed_values}"
            )
        self._auto_tiering = auto_tiering

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
