# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateShardPeerWithExadbXsDetails(object):
    """
    Details required for creation of ExadbXs infrastructure based shard peer.
    """

    #: A constant which can be used with the protection_mode property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    #: A constant which can be used with the protection_mode property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "MAXIMUM_PROTECTION"
    PROTECTION_MODE_MAXIMUM_PROTECTION = "MAXIMUM_PROTECTION"

    #: A constant which can be used with the transport_type property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "SYNC"
    TRANSPORT_TYPE_SYNC = "SYNC"

    #: A constant which can be used with the transport_type property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "ASYNC"
    TRANSPORT_TYPE_ASYNC = "ASYNC"

    #: A constant which can be used with the transport_type property of a CreateShardPeerWithExadbXsDetails.
    #: This constant has a value of "FASTSYNC"
    TRANSPORT_TYPE_FASTSYNC = "FASTSYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateShardPeerWithExadbXsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this CreateShardPeerWithExadbXsDetails.
        :type vm_cluster_id: str

        :param protection_mode:
            The value to assign to the protection_mode property of this CreateShardPeerWithExadbXsDetails.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"
        :type protection_mode: str

        :param transport_type:
            The value to assign to the transport_type property of this CreateShardPeerWithExadbXsDetails.
            Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"
        :type transport_type: str

        """
        self.swagger_types = {
            'vm_cluster_id': 'str',
            'protection_mode': 'str',
            'transport_type': 'str'
        }
        self.attribute_map = {
            'vm_cluster_id': 'vmClusterId',
            'protection_mode': 'protectionMode',
            'transport_type': 'transportType'
        }
        self._vm_cluster_id = None
        self._protection_mode = None
        self._transport_type = None

    @property
    def vm_cluster_id(self):
        """
        **[Required]** Gets the vm_cluster_id of this CreateShardPeerWithExadbXsDetails.
        The `OCID`__ of the VM Cluster for the shard peer.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this CreateShardPeerWithExadbXsDetails.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this CreateShardPeerWithExadbXsDetails.
        The `OCID`__ of the VM Cluster for the shard peer.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this CreateShardPeerWithExadbXsDetails.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this CreateShardPeerWithExadbXsDetails.
        The protectionMode for the shard peer.

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"


        :return: The protection_mode of this CreateShardPeerWithExadbXsDetails.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this CreateShardPeerWithExadbXsDetails.
        The protectionMode for the shard peer.


        :param protection_mode: The protection_mode of this CreateShardPeerWithExadbXsDetails.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `protection_mode`, must be None or one of {allowed_values}"
            )
        self._protection_mode = protection_mode

    @property
    def transport_type(self):
        """
        Gets the transport_type of this CreateShardPeerWithExadbXsDetails.
        The redo transport type to use for this Data Guard association.

        Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"


        :return: The transport_type of this CreateShardPeerWithExadbXsDetails.
        :rtype: str
        """
        return self._transport_type

    @transport_type.setter
    def transport_type(self, transport_type):
        """
        Sets the transport_type of this CreateShardPeerWithExadbXsDetails.
        The redo transport type to use for this Data Guard association.


        :param transport_type: The transport_type of this CreateShardPeerWithExadbXsDetails.
        :type: str
        """
        allowed_values = ["SYNC", "ASYNC", "FASTSYNC"]
        if not value_allowed_none_or_none_sentinel(transport_type, allowed_values):
            raise ValueError(
                f"Invalid value for `transport_type`, must be None or one of {allowed_values}"
            )
        self._transport_type = transport_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
