# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ArtifactDetails(object):
    """
    Patch artifact description and content details.
    """

    #: A constant which can be used with the category property of a ArtifactDetails.
    #: This constant has a value of "GENERIC"
    CATEGORY_GENERIC = "GENERIC"

    #: A constant which can be used with the category property of a ArtifactDetails.
    #: This constant has a value of "PLATFORM_SPECIFIC"
    CATEGORY_PLATFORM_SPECIFIC = "PLATFORM_SPECIFIC"

    def __init__(self, **kwargs):
        """
        Initializes a new ArtifactDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.PlatformSpecificArtifactDetails`
        * :class:`~oci.fleet_apps_management.models.GenericArtifactDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param category:
            The value to assign to the category property of this ArtifactDetails.
            Allowed values for this property are: "GENERIC", "PLATFORM_SPECIFIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type category: str

        """
        self.swagger_types = {
            'category': 'str'
        }
        self.attribute_map = {
            'category': 'category'
        }
        self._category = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['category']

        if type == 'PLATFORM_SPECIFIC':
            return 'PlatformSpecificArtifactDetails'

        if type == 'GENERIC':
            return 'GenericArtifactDetails'
        else:
            return 'ArtifactDetails'

    @property
    def category(self):
        """
        **[Required]** Gets the category of this ArtifactDetails.
        Artifact category details.

        Allowed values for this property are: "GENERIC", "PLATFORM_SPECIFIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The category of this ArtifactDetails.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this ArtifactDetails.
        Artifact category details.


        :param category: The category of this ArtifactDetails.
        :type: str
        """
        allowed_values = ["GENERIC", "PLATFORM_SPECIFIC"]
        if not value_allowed_none_or_none_sentinel(category, allowed_values):
            category = 'UNKNOWN_ENUM_VALUE'
        self._category = category

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
