# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportRunbookPrecheckDetails(object):
    """
    Request for precheck of Runbook import.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImportRunbookPrecheckDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ImportRunbookPrecheckDetails.
        :type compartment_id: str

        :param content_source:
            The value to assign to the content_source property of this ImportRunbookPrecheckDetails.
        :type content_source: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param content_destination:
            The value to assign to the content_destination property of this ImportRunbookPrecheckDetails.
        :type content_destination: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param import_as:
            The value to assign to the import_as property of this ImportRunbookPrecheckDetails.
        :type import_as: oci.fleet_apps_management.models.RunbookImportAs

        :param required_values:
            The value to assign to the required_values property of this ImportRunbookPrecheckDetails.
        :type required_values: list[oci.fleet_apps_management.models.ImportRunbookPrecheckRequiredValue]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'content_source': 'TransferRunbookContentDetails',
            'content_destination': 'TransferRunbookContentDetails',
            'import_as': 'RunbookImportAs',
            'required_values': 'list[ImportRunbookPrecheckRequiredValue]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'content_source': 'contentSource',
            'content_destination': 'contentDestination',
            'import_as': 'importAs',
            'required_values': 'requiredValues'
        }
        self._compartment_id = None
        self._content_source = None
        self._content_destination = None
        self._import_as = None
        self._required_values = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ImportRunbookPrecheckDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this ImportRunbookPrecheckDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ImportRunbookPrecheckDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this ImportRunbookPrecheckDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def content_source(self):
        """
        **[Required]** Gets the content_source of this ImportRunbookPrecheckDetails.

        :return: The content_source of this ImportRunbookPrecheckDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_source

    @content_source.setter
    def content_source(self, content_source):
        """
        Sets the content_source of this ImportRunbookPrecheckDetails.

        :param content_source: The content_source of this ImportRunbookPrecheckDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_source = content_source

    @property
    def content_destination(self):
        """
        **[Required]** Gets the content_destination of this ImportRunbookPrecheckDetails.

        :return: The content_destination of this ImportRunbookPrecheckDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_destination

    @content_destination.setter
    def content_destination(self, content_destination):
        """
        Sets the content_destination of this ImportRunbookPrecheckDetails.

        :param content_destination: The content_destination of this ImportRunbookPrecheckDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_destination = content_destination

    @property
    def import_as(self):
        """
        Gets the import_as of this ImportRunbookPrecheckDetails.

        :return: The import_as of this ImportRunbookPrecheckDetails.
        :rtype: oci.fleet_apps_management.models.RunbookImportAs
        """
        return self._import_as

    @import_as.setter
    def import_as(self, import_as):
        """
        Sets the import_as of this ImportRunbookPrecheckDetails.

        :param import_as: The import_as of this ImportRunbookPrecheckDetails.
        :type: oci.fleet_apps_management.models.RunbookImportAs
        """
        self._import_as = import_as

    @property
    def required_values(self):
        """
        Gets the required_values of this ImportRunbookPrecheckDetails.
        List of required values.


        :return: The required_values of this ImportRunbookPrecheckDetails.
        :rtype: list[oci.fleet_apps_management.models.ImportRunbookPrecheckRequiredValue]
        """
        return self._required_values

    @required_values.setter
    def required_values(self, required_values):
        """
        Sets the required_values of this ImportRunbookPrecheckDetails.
        List of required values.


        :param required_values: The required_values of this ImportRunbookPrecheckDetails.
        :type: list[oci.fleet_apps_management.models.ImportRunbookPrecheckRequiredValue]
        """
        self._required_values = required_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
