# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .base_variable import BaseVariable
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MultilineVariable(BaseVariable):
    """
    Multiline variable.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MultilineVariable object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.MultilineVariable.type` attribute
        of this class is ``TEXT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this MultilineVariable.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"
        :type type: str

        :param title:
            The value to assign to the title property of this MultilineVariable.
        :type title: str

        :param description:
            The value to assign to the description property of this MultilineVariable.
        :type description: str

        :param is_required:
            The value to assign to the is_required property of this MultilineVariable.
        :type is_required: bool

        :param visible:
            The value to assign to the visible property of this MultilineVariable.
        :type visible: str

        :param default_value:
            The value to assign to the default_value property of this MultilineVariable.
        :type default_value: str

        :param pattern:
            The value to assign to the pattern property of this MultilineVariable.
        :type pattern: str

        :param is_multiline:
            The value to assign to the is_multiline property of this MultilineVariable.
        :type is_multiline: bool

        :param max_length:
            The value to assign to the max_length property of this MultilineVariable.
        :type max_length: int

        :param min_length:
            The value to assign to the min_length property of this MultilineVariable.
        :type min_length: int

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_required': 'bool',
            'visible': 'str',
            'default_value': 'str',
            'pattern': 'str',
            'is_multiline': 'bool',
            'max_length': 'int',
            'min_length': 'int'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_required': 'isRequired',
            'visible': 'visible',
            'default_value': 'defaultValue',
            'pattern': 'pattern',
            'is_multiline': 'isMultiline',
            'max_length': 'maxLength',
            'min_length': 'minLength'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_required = None
        self._visible = None
        self._default_value = None
        self._pattern = None
        self._is_multiline = None
        self._max_length = None
        self._min_length = None
        self._type = 'TEXT'

    @property
    def default_value(self):
        """
        Gets the default_value of this MultilineVariable.
        The default string value.


        :return: The default_value of this MultilineVariable.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this MultilineVariable.
        The default string value.


        :param default_value: The default_value of this MultilineVariable.
        :type: str
        """
        self._default_value = default_value

    @property
    def pattern(self):
        """
        Gets the pattern of this MultilineVariable.
        Regex pattern that the multiline input must match.


        :return: The pattern of this MultilineVariable.
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """
        Sets the pattern of this MultilineVariable.
        Regex pattern that the multiline input must match.


        :param pattern: The pattern of this MultilineVariable.
        :type: str
        """
        self._pattern = pattern

    @property
    def is_multiline(self):
        """
        Gets the is_multiline of this MultilineVariable.
        Indicates this input allows multiple lines of text.


        :return: The is_multiline of this MultilineVariable.
        :rtype: bool
        """
        return self._is_multiline

    @is_multiline.setter
    def is_multiline(self, is_multiline):
        """
        Sets the is_multiline of this MultilineVariable.
        Indicates this input allows multiple lines of text.


        :param is_multiline: The is_multiline of this MultilineVariable.
        :type: bool
        """
        self._is_multiline = is_multiline

    @property
    def max_length(self):
        """
        Gets the max_length of this MultilineVariable.
        Maximum number of characters allowed.


        :return: The max_length of this MultilineVariable.
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this MultilineVariable.
        Maximum number of characters allowed.


        :param max_length: The max_length of this MultilineVariable.
        :type: int
        """
        self._max_length = max_length

    @property
    def min_length(self):
        """
        Gets the min_length of this MultilineVariable.
        Minimum number of characters required.


        :return: The min_length of this MultilineVariable.
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """
        Sets the min_length of this MultilineVariable.
        Minimum number of characters required.


        :param min_length: The min_length of this MultilineVariable.
        :type: int
        """
        self._min_length = min_length

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
