# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecommendedPatchSummary(object):
    """
    Summary information about an recommended patches.
    """

    #: A constant which can be used with the severity property of a RecommendedPatchSummary.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the severity property of a RecommendedPatchSummary.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a RecommendedPatchSummary.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a RecommendedPatchSummary.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the patch_level property of a RecommendedPatchSummary.
    #: This constant has a value of "LATEST"
    PATCH_LEVEL_LATEST = "LATEST"

    #: A constant which can be used with the patch_level property of a RecommendedPatchSummary.
    #: This constant has a value of "LATEST_MINUS_ONE"
    PATCH_LEVEL_LATEST_MINUS_ONE = "LATEST_MINUS_ONE"

    #: A constant which can be used with the patch_level property of a RecommendedPatchSummary.
    #: This constant has a value of "LATEST_MINUS_TWO"
    PATCH_LEVEL_LATEST_MINUS_TWO = "LATEST_MINUS_TWO"

    def __init__(self, **kwargs):
        """
        Initializes a new RecommendedPatchSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patch_id:
            The value to assign to the patch_id property of this RecommendedPatchSummary.
        :type patch_id: str

        :param patch_name:
            The value to assign to the patch_name property of this RecommendedPatchSummary.
        :type patch_name: str

        :param patch_description:
            The value to assign to the patch_description property of this RecommendedPatchSummary.
        :type patch_description: str

        :param time_released:
            The value to assign to the time_released property of this RecommendedPatchSummary.
        :type time_released: datetime

        :param patch_type:
            The value to assign to the patch_type property of this RecommendedPatchSummary.
        :type patch_type: str

        :param severity:
            The value to assign to the severity property of this RecommendedPatchSummary.
            Allowed values for this property are: "CRITICAL", "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param patch_level:
            The value to assign to the patch_level property of this RecommendedPatchSummary.
            Allowed values for this property are: "LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type patch_level: str

        """
        self.swagger_types = {
            'patch_id': 'str',
            'patch_name': 'str',
            'patch_description': 'str',
            'time_released': 'datetime',
            'patch_type': 'str',
            'severity': 'str',
            'patch_level': 'str'
        }
        self.attribute_map = {
            'patch_id': 'patchId',
            'patch_name': 'patchName',
            'patch_description': 'patchDescription',
            'time_released': 'timeReleased',
            'patch_type': 'patchType',
            'severity': 'severity',
            'patch_level': 'patchLevel'
        }
        self._patch_id = None
        self._patch_name = None
        self._patch_description = None
        self._time_released = None
        self._patch_type = None
        self._severity = None
        self._patch_level = None

    @property
    def patch_id(self):
        """
        **[Required]** Gets the patch_id of this RecommendedPatchSummary.
        The OCID of the patch.


        :return: The patch_id of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._patch_id

    @patch_id.setter
    def patch_id(self, patch_id):
        """
        Sets the patch_id of this RecommendedPatchSummary.
        The OCID of the patch.


        :param patch_id: The patch_id of this RecommendedPatchSummary.
        :type: str
        """
        self._patch_id = patch_id

    @property
    def patch_name(self):
        """
        **[Required]** Gets the patch_name of this RecommendedPatchSummary.
        Name of the patch


        :return: The patch_name of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._patch_name

    @patch_name.setter
    def patch_name(self, patch_name):
        """
        Sets the patch_name of this RecommendedPatchSummary.
        Name of the patch


        :param patch_name: The patch_name of this RecommendedPatchSummary.
        :type: str
        """
        self._patch_name = patch_name

    @property
    def patch_description(self):
        """
        **[Required]** Gets the patch_description of this RecommendedPatchSummary.
        Description of the patch


        :return: The patch_description of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._patch_description

    @patch_description.setter
    def patch_description(self, patch_description):
        """
        Sets the patch_description of this RecommendedPatchSummary.
        Description of the patch


        :param patch_description: The patch_description of this RecommendedPatchSummary.
        :type: str
        """
        self._patch_description = patch_description

    @property
    def time_released(self):
        """
        Gets the time_released of this RecommendedPatchSummary.
        Date on which the patch was released


        :return: The time_released of this RecommendedPatchSummary.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this RecommendedPatchSummary.
        Date on which the patch was released


        :param time_released: The time_released of this RecommendedPatchSummary.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def patch_type(self):
        """
        Gets the patch_type of this RecommendedPatchSummary.
        Description of the patch


        :return: The patch_type of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._patch_type

    @patch_type.setter
    def patch_type(self, patch_type):
        """
        Sets the patch_type of this RecommendedPatchSummary.
        Description of the patch


        :param patch_type: The patch_type of this RecommendedPatchSummary.
        :type: str
        """
        self._patch_type = patch_type

    @property
    def severity(self):
        """
        Gets the severity of this RecommendedPatchSummary.
        Patch Severity.

        Allowed values for this property are: "CRITICAL", "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this RecommendedPatchSummary.
        Patch Severity.


        :param severity: The severity of this RecommendedPatchSummary.
        :type: str
        """
        allowed_values = ["CRITICAL", "HIGH", "MEDIUM", "LOW"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def patch_level(self):
        """
        Gets the patch_level of this RecommendedPatchSummary.
        Patch Level.

        Allowed values for this property are: "LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The patch_level of this RecommendedPatchSummary.
        :rtype: str
        """
        return self._patch_level

    @patch_level.setter
    def patch_level(self, patch_level):
        """
        Sets the patch_level of this RecommendedPatchSummary.
        Patch Level.


        :param patch_level: The patch_level of this RecommendedPatchSummary.
        :type: str
        """
        allowed_values = ["LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO"]
        if not value_allowed_none_or_none_sentinel(patch_level, allowed_values):
            patch_level = 'UNKNOWN_ENUM_VALUE'
        self._patch_level = patch_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
