# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFleetDetails(object):
    """
    The information to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFleetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateFleetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateFleetDetails.
        :type description: str

        :param notification_preferences:
            The value to assign to the notification_preferences property of this UpdateFleetDetails.
        :type notification_preferences: list[oci.fleet_apps_management.models.NotificationPreference]

        :param is_target_auto_confirm:
            The value to assign to the is_target_auto_confirm property of this UpdateFleetDetails.
        :type is_target_auto_confirm: bool

        :param resource_selection:
            The value to assign to the resource_selection property of this UpdateFleetDetails.
        :type resource_selection: oci.fleet_apps_management.models.ResourceSelection

        :param products:
            The value to assign to the products property of this UpdateFleetDetails.
        :type products: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFleetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFleetDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param environment_type:
            The value to assign to the environment_type property of this UpdateFleetDetails.
        :type environment_type: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'notification_preferences': 'list[NotificationPreference]',
            'is_target_auto_confirm': 'bool',
            'resource_selection': 'ResourceSelection',
            'products': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'environment_type': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'notification_preferences': 'notificationPreferences',
            'is_target_auto_confirm': 'isTargetAutoConfirm',
            'resource_selection': 'resourceSelection',
            'products': 'products',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'environment_type': 'environmentType'
        }
        self._display_name = None
        self._description = None
        self._notification_preferences = None
        self._is_target_auto_confirm = None
        self._resource_selection = None
        self._products = None
        self._freeform_tags = None
        self._defined_tags = None
        self._environment_type = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this UpdateFleetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this UpdateFleetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this UpdateFleetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this UpdateFleetDetails.
        :type: str
        """
        self._description = description

    @property
    def notification_preferences(self):
        """
        Gets the notification_preferences of this UpdateFleetDetails.
        Notification Preferences associated with the Fleet.
        An UPDATE operation replaces the existing notification preferences list entirely


        :return: The notification_preferences of this UpdateFleetDetails.
        :rtype: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        return self._notification_preferences

    @notification_preferences.setter
    def notification_preferences(self, notification_preferences):
        """
        Sets the notification_preferences of this UpdateFleetDetails.
        Notification Preferences associated with the Fleet.
        An UPDATE operation replaces the existing notification preferences list entirely


        :param notification_preferences: The notification_preferences of this UpdateFleetDetails.
        :type: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        self._notification_preferences = notification_preferences

    @property
    def is_target_auto_confirm(self):
        """
        Gets the is_target_auto_confirm of this UpdateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :return: The is_target_auto_confirm of this UpdateFleetDetails.
        :rtype: bool
        """
        return self._is_target_auto_confirm

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, is_target_auto_confirm):
        """
        Sets the is_target_auto_confirm of this UpdateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :param is_target_auto_confirm: The is_target_auto_confirm of this UpdateFleetDetails.
        :type: bool
        """
        self._is_target_auto_confirm = is_target_auto_confirm

    @property
    def resource_selection(self):
        """
        Gets the resource_selection of this UpdateFleetDetails.

        :return: The resource_selection of this UpdateFleetDetails.
        :rtype: oci.fleet_apps_management.models.ResourceSelection
        """
        return self._resource_selection

    @resource_selection.setter
    def resource_selection(self, resource_selection):
        """
        Sets the resource_selection of this UpdateFleetDetails.

        :param resource_selection: The resource_selection of this UpdateFleetDetails.
        :type: oci.fleet_apps_management.models.ResourceSelection
        """
        self._resource_selection = resource_selection

    @property
    def products(self):
        """
        Gets the products of this UpdateFleetDetails.
        Products associated with the Fleet.
        Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.


        :return: The products of this UpdateFleetDetails.
        :rtype: list[str]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this UpdateFleetDetails.
        Products associated with the Fleet.
        Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.


        :param products: The products of this UpdateFleetDetails.
        :type: list[str]
        """
        self._products = products

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateFleetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateFleetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateFleetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateFleetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def environment_type(self):
        """
        Gets the environment_type of this UpdateFleetDetails.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :return: The environment_type of this UpdateFleetDetails.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this UpdateFleetDetails.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :param environment_type: The environment_type of this UpdateFleetDetails.
        :type: str
        """
        self._environment_type = environment_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
