# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOnboardingDetails(object):
    """
    The information about updating onboarding.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOnboardingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_fams_tag_enabled:
            The value to assign to the is_fams_tag_enabled property of this UpdateOnboardingDetails.
        :type is_fams_tag_enabled: bool

        :param is_cost_tracking_tag_enabled:
            The value to assign to the is_cost_tracking_tag_enabled property of this UpdateOnboardingDetails.
        :type is_cost_tracking_tag_enabled: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOnboardingDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOnboardingDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'is_fams_tag_enabled': 'bool',
            'is_cost_tracking_tag_enabled': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'is_fams_tag_enabled': 'isFamsTagEnabled',
            'is_cost_tracking_tag_enabled': 'isCostTrackingTagEnabled',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._is_fams_tag_enabled = None
        self._is_cost_tracking_tag_enabled = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def is_fams_tag_enabled(self):
        """
        Gets the is_fams_tag_enabled of this UpdateOnboardingDetails.
        A value determining Fleet Application Management tag is enabled or not


        :return: The is_fams_tag_enabled of this UpdateOnboardingDetails.
        :rtype: bool
        """
        return self._is_fams_tag_enabled

    @is_fams_tag_enabled.setter
    def is_fams_tag_enabled(self, is_fams_tag_enabled):
        """
        Sets the is_fams_tag_enabled of this UpdateOnboardingDetails.
        A value determining Fleet Application Management tag is enabled or not


        :param is_fams_tag_enabled: The is_fams_tag_enabled of this UpdateOnboardingDetails.
        :type: bool
        """
        self._is_fams_tag_enabled = is_fams_tag_enabled

    @property
    def is_cost_tracking_tag_enabled(self):
        """
        Gets the is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        A value determining if cost tracking tag is enabled or not


        :return: The is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        :rtype: bool
        """
        return self._is_cost_tracking_tag_enabled

    @is_cost_tracking_tag_enabled.setter
    def is_cost_tracking_tag_enabled(self, is_cost_tracking_tag_enabled):
        """
        Sets the is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        A value determining if cost tracking tag is enabled or not


        :param is_cost_tracking_tag_enabled: The is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        :type: bool
        """
        self._is_cost_tracking_tag_enabled = is_cost_tracking_tag_enabled

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOnboardingDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateOnboardingDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOnboardingDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateOnboardingDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOnboardingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateOnboardingDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOnboardingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateOnboardingDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
