# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .model_data_source import ModelDataSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HuggingFaceModel(ModelDataSource):
    """
    Configuration for importing a model from Hugging Face. Requires the model ID
    and a reference to the token stored in a vault for authenticated access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HuggingFaceModel object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai.models.HuggingFaceModel.source_type` attribute
        of this class is ``HUGGING_FACE_MODEL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this HuggingFaceModel.
            Allowed values for this property are: "HUGGING_FACE_MODEL", "OBJECT_STORAGE_OBJECT"
        :type source_type: str

        :param model_id:
            The value to assign to the model_id property of this HuggingFaceModel.
        :type model_id: str

        :param access_token:
            The value to assign to the access_token property of this HuggingFaceModel.
        :type access_token: str

        :param branch:
            The value to assign to the branch property of this HuggingFaceModel.
        :type branch: str

        :param commit:
            The value to assign to the commit property of this HuggingFaceModel.
        :type commit: str

        """
        self.swagger_types = {
            'source_type': 'str',
            'model_id': 'str',
            'access_token': 'str',
            'branch': 'str',
            'commit': 'str'
        }
        self.attribute_map = {
            'source_type': 'sourceType',
            'model_id': 'modelId',
            'access_token': 'accessToken',
            'branch': 'branch',
            'commit': 'commit'
        }
        self._source_type = None
        self._model_id = None
        self._access_token = None
        self._branch = None
        self._commit = None
        self._source_type = 'HUGGING_FACE_MODEL'

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this HuggingFaceModel.
        The full model OCID from Hugging Face, typically in the format
        \"org/model-name\" (e.g., \"meta-llama/Llama-2-7b\").


        :return: The model_id of this HuggingFaceModel.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this HuggingFaceModel.
        The full model OCID from Hugging Face, typically in the format
        \"org/model-name\" (e.g., \"meta-llama/Llama-2-7b\").


        :param model_id: The model_id of this HuggingFaceModel.
        :type: str
        """
        self._model_id = model_id

    @property
    def access_token(self):
        """
        Gets the access_token of this HuggingFaceModel.
        Hugging Face access token to authenticate requests for restricted models.
        This token will be securely stored in OCI Vault.


        :return: The access_token of this HuggingFaceModel.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """
        Sets the access_token of this HuggingFaceModel.
        Hugging Face access token to authenticate requests for restricted models.
        This token will be securely stored in OCI Vault.


        :param access_token: The access_token of this HuggingFaceModel.
        :type: str
        """
        self._access_token = access_token

    @property
    def branch(self):
        """
        Gets the branch of this HuggingFaceModel.
        The name of the branch in the Hugging Face repository to import the model from.
        If not specified, \"main\" will be used by default.
        If you provide both a branch and a commit hash, the model will be imported from the specified commit.


        :return: The branch of this HuggingFaceModel.
        :rtype: str
        """
        return self._branch

    @branch.setter
    def branch(self, branch):
        """
        Sets the branch of this HuggingFaceModel.
        The name of the branch in the Hugging Face repository to import the model from.
        If not specified, \"main\" will be used by default.
        If you provide both a branch and a commit hash, the model will be imported from the specified commit.


        :param branch: The branch of this HuggingFaceModel.
        :type: str
        """
        self._branch = branch

    @property
    def commit(self):
        """
        Gets the commit of this HuggingFaceModel.
        The commit hash in the Hugging Face repository to import the model from.
        If both a branch and a commit are provided, the commit hash will be used.


        :return: The commit of this HuggingFaceModel.
        :rtype: str
        """
        return self._commit

    @commit.setter
    def commit(self, commit):
        """
        Sets the commit of this HuggingFaceModel.
        The commit hash in the Hugging Face repository to import the model from.
        If both a branch and a commit are provided, the commit hash will be used.


        :param commit: The commit of this HuggingFaceModel.
        :type: str
        """
        self._commit = commit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
