# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .http_endpoint_auth_scope_config import HttpEndpointAuthScopeConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointApiKeyAuthScopeConfig(HttpEndpointAuthScopeConfig):
    """
    Specifies authentication using an API key injected either as a header or query parameter.

    - If `authScope = AGENT`: The API key is retrieved from OCI Vault using the agent\u2019s identity.
    """

    #: A constant which can be used with the key_location property of a HttpEndpointApiKeyAuthScopeConfig.
    #: This constant has a value of "HEADER"
    KEY_LOCATION_HEADER = "HEADER"

    #: A constant which can be used with the key_location property of a HttpEndpointApiKeyAuthScopeConfig.
    #: This constant has a value of "QUERY_PARAMETER"
    KEY_LOCATION_QUERY_PARAMETER = "QUERY_PARAMETER"

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointApiKeyAuthScopeConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.HttpEndpointApiKeyAuthScopeConfig.http_endpoint_auth_scope_config_type` attribute
        of this class is ``HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_scope_config_type:
            The value to assign to the http_endpoint_auth_scope_config_type property of this HttpEndpointApiKeyAuthScopeConfig.
            Allowed values for this property are: "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type http_endpoint_auth_scope_config_type: str

        :param vault_secret_id:
            The value to assign to the vault_secret_id property of this HttpEndpointApiKeyAuthScopeConfig.
        :type vault_secret_id: str

        :param key_location:
            The value to assign to the key_location property of this HttpEndpointApiKeyAuthScopeConfig.
            Allowed values for this property are: "HEADER", "QUERY_PARAMETER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type key_location: str

        :param key_name:
            The value to assign to the key_name property of this HttpEndpointApiKeyAuthScopeConfig.
        :type key_name: str

        """
        self.swagger_types = {
            'http_endpoint_auth_scope_config_type': 'str',
            'vault_secret_id': 'str',
            'key_location': 'str',
            'key_name': 'str'
        }
        self.attribute_map = {
            'http_endpoint_auth_scope_config_type': 'httpEndpointAuthScopeConfigType',
            'vault_secret_id': 'vaultSecretId',
            'key_location': 'keyLocation',
            'key_name': 'keyName'
        }
        self._http_endpoint_auth_scope_config_type = None
        self._vault_secret_id = None
        self._key_location = None
        self._key_name = None
        self._http_endpoint_auth_scope_config_type = 'HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG'

    @property
    def vault_secret_id(self):
        """
        Gets the vault_secret_id of this HttpEndpointApiKeyAuthScopeConfig.
        The OCID of the vault secret with API key.
        Required when `authScope` is AGENT.


        :return: The vault_secret_id of this HttpEndpointApiKeyAuthScopeConfig.
        :rtype: str
        """
        return self._vault_secret_id

    @vault_secret_id.setter
    def vault_secret_id(self, vault_secret_id):
        """
        Sets the vault_secret_id of this HttpEndpointApiKeyAuthScopeConfig.
        The OCID of the vault secret with API key.
        Required when `authScope` is AGENT.


        :param vault_secret_id: The vault_secret_id of this HttpEndpointApiKeyAuthScopeConfig.
        :type: str
        """
        self._vault_secret_id = vault_secret_id

    @property
    def key_location(self):
        """
        **[Required]** Gets the key_location of this HttpEndpointApiKeyAuthScopeConfig.
        The location of the API key in the request.

        Allowed values for this property are: "HEADER", "QUERY_PARAMETER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The key_location of this HttpEndpointApiKeyAuthScopeConfig.
        :rtype: str
        """
        return self._key_location

    @key_location.setter
    def key_location(self, key_location):
        """
        Sets the key_location of this HttpEndpointApiKeyAuthScopeConfig.
        The location of the API key in the request.


        :param key_location: The key_location of this HttpEndpointApiKeyAuthScopeConfig.
        :type: str
        """
        allowed_values = ["HEADER", "QUERY_PARAMETER"]
        if not value_allowed_none_or_none_sentinel(key_location, allowed_values):
            key_location = 'UNKNOWN_ENUM_VALUE'
        self._key_location = key_location

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this HttpEndpointApiKeyAuthScopeConfig.
        The name of the key parameter in the location.


        :return: The key_name of this HttpEndpointApiKeyAuthScopeConfig.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this HttpEndpointApiKeyAuthScopeConfig.
        The name of the key parameter in the location.


        :param key_name: The key_name of this HttpEndpointApiKeyAuthScopeConfig.
        :type: str
        """
        self._key_name = key_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
