# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .secret_detail import SecretDetail
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdcsSecret(SecretDetail):
    """
    The details of IDCS configured as OpenID setting in OpenSearch.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdcsSecret object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.IdcsSecret.type` attribute
        of this class is ``IDCS_SECRET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IdcsSecret.
            Allowed values for this property are: "IDCS_SECRET", "BASIC_AUTH_SECRET"
        :type type: str

        :param idcs_url:
            The value to assign to the idcs_url property of this IdcsSecret.
        :type idcs_url: str

        :param client_id:
            The value to assign to the client_id property of this IdcsSecret.
        :type client_id: str

        :param vault_secret_id:
            The value to assign to the vault_secret_id property of this IdcsSecret.
        :type vault_secret_id: str

        :param scope_url:
            The value to assign to the scope_url property of this IdcsSecret.
        :type scope_url: str

        """
        self.swagger_types = {
            'type': 'str',
            'idcs_url': 'str',
            'client_id': 'str',
            'vault_secret_id': 'str',
            'scope_url': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'idcs_url': 'idcsUrl',
            'client_id': 'clientId',
            'vault_secret_id': 'vaultSecretId',
            'scope_url': 'scopeUrl'
        }
        self._type = None
        self._idcs_url = None
        self._client_id = None
        self._vault_secret_id = None
        self._scope_url = None
        self._type = 'IDCS_SECRET'

    @property
    def idcs_url(self):
        """
        **[Required]** Gets the idcs_url of this IdcsSecret.
        The URL represent authentication url of the IDCS.


        :return: The idcs_url of this IdcsSecret.
        :rtype: str
        """
        return self._idcs_url

    @idcs_url.setter
    def idcs_url(self, idcs_url):
        """
        Sets the idcs_url of this IdcsSecret.
        The URL represent authentication url of the IDCS.


        :param idcs_url: The idcs_url of this IdcsSecret.
        :type: str
        """
        self._idcs_url = idcs_url

    @property
    def client_id(self):
        """
        **[Required]** Gets the client_id of this IdcsSecret.
        The IDCS Connect clientId.


        :return: The client_id of this IdcsSecret.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this IdcsSecret.
        The IDCS Connect clientId.


        :param client_id: The client_id of this IdcsSecret.
        :type: str
        """
        self._client_id = client_id

    @property
    def vault_secret_id(self):
        """
        **[Required]** Gets the vault_secret_id of this IdcsSecret.
        The `OCID`__ of the secret for client secret.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vault_secret_id of this IdcsSecret.
        :rtype: str
        """
        return self._vault_secret_id

    @vault_secret_id.setter
    def vault_secret_id(self, vault_secret_id):
        """
        Sets the vault_secret_id of this IdcsSecret.
        The `OCID`__ of the secret for client secret.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vault_secret_id: The vault_secret_id of this IdcsSecret.
        :type: str
        """
        self._vault_secret_id = vault_secret_id

    @property
    def scope_url(self):
        """
        **[Required]** Gets the scope_url of this IdcsSecret.
        Fully qualified scope url


        :return: The scope_url of this IdcsSecret.
        :rtype: str
        """
        return self._scope_url

    @scope_url.setter
    def scope_url(self, scope_url):
        """
        Sets the scope_url of this IdcsSecret.
        Fully qualified scope url


        :param scope_url: The scope_url of this IdcsSecret.
        :type: str
        """
        self._scope_url = scope_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
