# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolOutput(object):
    """
    Base schema for tool outputs. Identified by `toolOutputType`, which determines the format of the output content.
    """

    #: A constant which can be used with the tool_output_type property of a ToolOutput.
    #: This constant has a value of "GENERIC_TOOL_OUTPUT"
    TOOL_OUTPUT_TYPE_GENERIC_TOOL_OUTPUT = "GENERIC_TOOL_OUTPUT"

    #: A constant which can be used with the tool_output_type property of a ToolOutput.
    #: This constant has a value of "SQL_TOOL_OUTPUT"
    TOOL_OUTPUT_TYPE_SQL_TOOL_OUTPUT = "SQL_TOOL_OUTPUT"

    #: A constant which can be used with the tool_output_type property of a ToolOutput.
    #: This constant has a value of "RAG_TOOL_OUTPUT"
    TOOL_OUTPUT_TYPE_RAG_TOOL_OUTPUT = "RAG_TOOL_OUTPUT"

    def __init__(self, **kwargs):
        """
        Initializes a new ToolOutput object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent_runtime.models.GenericToolOutput`
        * :class:`~oci.generative_ai_agent_runtime.models.SqlToolOutput`
        * :class:`~oci.generative_ai_agent_runtime.models.RagToolOutput`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_id:
            The value to assign to the tool_id property of this ToolOutput.
        :type tool_id: str

        :param tool_name:
            The value to assign to the tool_name property of this ToolOutput.
        :type tool_name: str

        :param tool_output_type:
            The value to assign to the tool_output_type property of this ToolOutput.
            Allowed values for this property are: "GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type tool_output_type: str

        """
        self.swagger_types = {
            'tool_id': 'str',
            'tool_name': 'str',
            'tool_output_type': 'str'
        }
        self.attribute_map = {
            'tool_id': 'toolId',
            'tool_name': 'toolName',
            'tool_output_type': 'toolOutputType'
        }
        self._tool_id = None
        self._tool_name = None
        self._tool_output_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['toolOutputType']

        if type == 'GENERIC_TOOL_OUTPUT':
            return 'GenericToolOutput'

        if type == 'SQL_TOOL_OUTPUT':
            return 'SqlToolOutput'

        if type == 'RAG_TOOL_OUTPUT':
            return 'RagToolOutput'
        else:
            return 'ToolOutput'

    @property
    def tool_id(self):
        """
        **[Required]** Gets the tool_id of this ToolOutput.
        Specifies the unique OCID of the tool.


        :return: The tool_id of this ToolOutput.
        :rtype: str
        """
        return self._tool_id

    @tool_id.setter
    def tool_id(self, tool_id):
        """
        Sets the tool_id of this ToolOutput.
        Specifies the unique OCID of the tool.


        :param tool_id: The tool_id of this ToolOutput.
        :type: str
        """
        self._tool_id = tool_id

    @property
    def tool_name(self):
        """
        Gets the tool_name of this ToolOutput.
        Specifies the display name of the tool.


        :return: The tool_name of this ToolOutput.
        :rtype: str
        """
        return self._tool_name

    @tool_name.setter
    def tool_name(self, tool_name):
        """
        Sets the tool_name of this ToolOutput.
        Specifies the display name of the tool.


        :param tool_name: The tool_name of this ToolOutput.
        :type: str
        """
        self._tool_name = tool_name

    @property
    def tool_output_type(self):
        """
        **[Required]** Gets the tool_output_type of this ToolOutput.
        Specifies the type of tool output (e.g., GENERIC_TOOL_OUTPUT, SQL_TOOL_OUTPUT).

        Allowed values for this property are: "GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The tool_output_type of this ToolOutput.
        :rtype: str
        """
        return self._tool_output_type

    @tool_output_type.setter
    def tool_output_type(self, tool_output_type):
        """
        Sets the tool_output_type of this ToolOutput.
        Specifies the type of tool output (e.g., GENERIC_TOOL_OUTPUT, SQL_TOOL_OUTPUT).


        :param tool_output_type: The tool_output_type of this ToolOutput.
        :type: str
        """
        allowed_values = ["GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT"]
        if not value_allowed_none_or_none_sentinel(tool_output_type, allowed_values):
            tool_output_type = 'UNKNOWN_ENUM_VALUE'
        self._tool_output_type = tool_output_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
