# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SummarizeTextResult(object):
    """
    Summarize text result to return to caller.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SummarizeTextResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SummarizeTextResult.
        :type id: str

        :param input:
            The value to assign to the input property of this SummarizeTextResult.
        :type input: str

        :param summary:
            The value to assign to the summary property of this SummarizeTextResult.
        :type summary: str

        :param model_id:
            The value to assign to the model_id property of this SummarizeTextResult.
        :type model_id: str

        :param model_version:
            The value to assign to the model_version property of this SummarizeTextResult.
        :type model_version: str

        """
        self.swagger_types = {
            'id': 'str',
            'input': 'str',
            'summary': 'str',
            'model_id': 'str',
            'model_version': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'input': 'input',
            'summary': 'summary',
            'model_id': 'modelId',
            'model_version': 'modelVersion'
        }
        self._id = None
        self._input = None
        self._summary = None
        self._model_id = None
        self._model_version = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SummarizeTextResult.
        A unique identifier for this SummarizeTextResult.


        :return: The id of this SummarizeTextResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SummarizeTextResult.
        A unique identifier for this SummarizeTextResult.


        :param id: The id of this SummarizeTextResult.
        :type: str
        """
        self._id = id

    @property
    def input(self):
        """
        Gets the input of this SummarizeTextResult.
        The original input. Only included if \"isEcho\" set to true.


        :return: The input of this SummarizeTextResult.
        :rtype: str
        """
        return self._input

    @input.setter
    def input(self, input):
        """
        Sets the input of this SummarizeTextResult.
        The original input. Only included if \"isEcho\" set to true.


        :param input: The input of this SummarizeTextResult.
        :type: str
        """
        self._input = input

    @property
    def summary(self):
        """
        **[Required]** Gets the summary of this SummarizeTextResult.
        Summary result corresponding to input.


        :return: The summary of this SummarizeTextResult.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this SummarizeTextResult.
        Summary result corresponding to input.


        :param summary: The summary of this SummarizeTextResult.
        :type: str
        """
        self._summary = summary

    @property
    def model_id(self):
        """
        Gets the model_id of this SummarizeTextResult.
        The OCID of the model used in this inference request.


        :return: The model_id of this SummarizeTextResult.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this SummarizeTextResult.
        The OCID of the model used in this inference request.


        :param model_id: The model_id of this SummarizeTextResult.
        :type: str
        """
        self._model_id = model_id

    @property
    def model_version(self):
        """
        Gets the model_version of this SummarizeTextResult.
        The version of the model.


        :return: The model_version of this SummarizeTextResult.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this SummarizeTextResult.
        The version of the model.


        :param model_version: The model_version of this SummarizeTextResult.
        :type: str
        """
        self._model_version = model_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
