# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WebSearchOptions(object):
    """
    Options for performing a web search to augment the response.
    """

    #: A constant which can be used with the search_context_size property of a WebSearchOptions.
    #: This constant has a value of "HIGH"
    SEARCH_CONTEXT_SIZE_HIGH = "HIGH"

    #: A constant which can be used with the search_context_size property of a WebSearchOptions.
    #: This constant has a value of "MEDIUM"
    SEARCH_CONTEXT_SIZE_MEDIUM = "MEDIUM"

    #: A constant which can be used with the search_context_size property of a WebSearchOptions.
    #: This constant has a value of "LOW"
    SEARCH_CONTEXT_SIZE_LOW = "LOW"

    def __init__(self, **kwargs):
        """
        Initializes a new WebSearchOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param search_context_size:
            The value to assign to the search_context_size property of this WebSearchOptions.
            Allowed values for this property are: "HIGH", "MEDIUM", "LOW"
        :type search_context_size: str

        :param user_location:
            The value to assign to the user_location property of this WebSearchOptions.
        :type user_location: oci.generative_ai_inference.models.ApproximateLocation

        """
        self.swagger_types = {
            'search_context_size': 'str',
            'user_location': 'ApproximateLocation'
        }
        self.attribute_map = {
            'search_context_size': 'searchContextSize',
            'user_location': 'userLocation'
        }
        self._search_context_size = None
        self._user_location = None

    @property
    def search_context_size(self):
        """
        Gets the search_context_size of this WebSearchOptions.
        Specifies the size of the web search context.
          - HIGH: Most comprehensive context, highest cost, slower response.
          - MEDIUM: Balanced context, cost, and latency.
          - LOW: Least context, lowest cost, fastest response, but potentially lower answer quality.

        Allowed values for this property are: "HIGH", "MEDIUM", "LOW"


        :return: The search_context_size of this WebSearchOptions.
        :rtype: str
        """
        return self._search_context_size

    @search_context_size.setter
    def search_context_size(self, search_context_size):
        """
        Sets the search_context_size of this WebSearchOptions.
        Specifies the size of the web search context.
          - HIGH: Most comprehensive context, highest cost, slower response.
          - MEDIUM: Balanced context, cost, and latency.
          - LOW: Least context, lowest cost, fastest response, but potentially lower answer quality.


        :param search_context_size: The search_context_size of this WebSearchOptions.
        :type: str
        """
        allowed_values = ["HIGH", "MEDIUM", "LOW"]
        if not value_allowed_none_or_none_sentinel(search_context_size, allowed_values):
            raise ValueError(
                f"Invalid value for `search_context_size`, must be None or one of {allowed_values}"
            )
        self._search_context_size = search_context_size

    @property
    def user_location(self):
        """
        Gets the user_location of this WebSearchOptions.

        :return: The user_location of this WebSearchOptions.
        :rtype: oci.generative_ai_inference.models.ApproximateLocation
        """
        return self._user_location

    @user_location.setter
    def user_location(self, user_location):
        """
        Sets the user_location of this WebSearchOptions.

        :param user_location: The user_location of this WebSearchOptions.
        :type: oci.generative_ai_inference.models.ApproximateLocation
        """
        self._user_location = user_location

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
