# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrevalidateShardedDatabaseResult(object):
    """
    Response of prevalidation api.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrevalidateShardedDatabaseResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param validation_result:
            The value to assign to the validation_result property of this PrevalidateShardedDatabaseResult.
        :type validation_result: dict(str, object)

        """
        self.swagger_types = {
            'validation_result': 'dict(str, object)'
        }
        self.attribute_map = {
            'validation_result': 'validationResult'
        }
        self._validation_result = None

    @property
    def validation_result(self):
        """
        **[Required]** Gets the validation_result of this PrevalidateShardedDatabaseResult.
        Prevalidation result based on input payload.


        :return: The validation_result of this PrevalidateShardedDatabaseResult.
        :rtype: dict(str, object)
        """
        return self._validation_result

    @validation_result.setter
    def validation_result(self, validation_result):
        """
        Sets the validation_result of this PrevalidateShardedDatabaseResult.
        Prevalidation result based on input payload.


        :param validation_result: The validation_result of this PrevalidateShardedDatabaseResult.
        :type: dict(str, object)
        """
        self._validation_result = validation_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
