# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .connection_summary import ConnectionSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IcebergConnectionSummary(ConnectionSummary):
    """
    Summary of the Iceberg Connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IcebergConnectionSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.IcebergConnectionSummary.connection_type` attribute
        of this class is ``ICEBERG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this IcebergConnectionSummary.
            Allowed values for this property are: "GOLDENGATE", "KAFKA", "KAFKA_SCHEMA_REGISTRY", "MYSQL", "JAVA_MESSAGE_SERVICE", "MICROSOFT_SQLSERVER", "OCI_OBJECT_STORAGE", "ORACLE", "AZURE_DATA_LAKE_STORAGE", "POSTGRESQL", "AZURE_SYNAPSE_ANALYTICS", "SNOWFLAKE", "AMAZON_S3", "HDFS", "ORACLE_AI_DATA_PLATFORM", "ORACLE_NOSQL", "MONGODB", "AMAZON_KINESIS", "AMAZON_REDSHIFT", "DB2", "REDIS", "ELASTICSEARCH", "GENERIC", "GOOGLE_CLOUD_STORAGE", "GOOGLE_BIGQUERY", "DATABRICKS", "GOOGLE_PUBSUB", "MICROSOFT_FABRIC", "ICEBERG"
        :type connection_type: str

        :param id:
            The value to assign to the id property of this IcebergConnectionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this IcebergConnectionSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this IcebergConnectionSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this IcebergConnectionSummary.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this IcebergConnectionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this IcebergConnectionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this IcebergConnectionSummary.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this IcebergConnectionSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this IcebergConnectionSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this IcebergConnectionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this IcebergConnectionSummary.
        :type time_updated: datetime

        :param vault_id:
            The value to assign to the vault_id property of this IcebergConnectionSummary.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this IcebergConnectionSummary.
        :type key_id: str

        :param ingress_ips:
            The value to assign to the ingress_ips property of this IcebergConnectionSummary.
        :type ingress_ips: list[oci.golden_gate.models.IngressIpDetails]

        :param nsg_ids:
            The value to assign to the nsg_ids property of this IcebergConnectionSummary.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this IcebergConnectionSummary.
        :type subnet_id: str

        :param routing_method:
            The value to assign to the routing_method property of this IcebergConnectionSummary.
            Allowed values for this property are: "SHARED_SERVICE_ENDPOINT", "SHARED_DEPLOYMENT_ENDPOINT", "DEDICATED_ENDPOINT"
        :type routing_method: str

        :param locks:
            The value to assign to the locks property of this IcebergConnectionSummary.
        :type locks: list[oci.golden_gate.models.ResourceLock]

        :param does_use_secret_ids:
            The value to assign to the does_use_secret_ids property of this IcebergConnectionSummary.
        :type does_use_secret_ids: bool

        :param subscription_id:
            The value to assign to the subscription_id property of this IcebergConnectionSummary.
        :type subscription_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this IcebergConnectionSummary.
        :type cluster_placement_group_id: str

        :param security_attributes:
            The value to assign to the security_attributes property of this IcebergConnectionSummary.
        :type security_attributes: dict(str, dict(str, object))

        :param technology_type:
            The value to assign to the technology_type property of this IcebergConnectionSummary.
        :type technology_type: str

        :param catalog:
            The value to assign to the catalog property of this IcebergConnectionSummary.
        :type catalog: oci.golden_gate.models.IcebergCatalogSummary

        :param storage:
            The value to assign to the storage property of this IcebergConnectionSummary.
        :type storage: oci.golden_gate.models.IcebergStorageSummary

        """
        self.swagger_types = {
            'connection_type': 'str',
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'vault_id': 'str',
            'key_id': 'str',
            'ingress_ips': 'list[IngressIpDetails]',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'routing_method': 'str',
            'locks': 'list[ResourceLock]',
            'does_use_secret_ids': 'bool',
            'subscription_id': 'str',
            'cluster_placement_group_id': 'str',
            'security_attributes': 'dict(str, dict(str, object))',
            'technology_type': 'str',
            'catalog': 'IcebergCatalogSummary',
            'storage': 'IcebergStorageSummary'
        }
        self.attribute_map = {
            'connection_type': 'connectionType',
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'ingress_ips': 'ingressIps',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'routing_method': 'routingMethod',
            'locks': 'locks',
            'does_use_secret_ids': 'doesUseSecretIds',
            'subscription_id': 'subscriptionId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'security_attributes': 'securityAttributes',
            'technology_type': 'technologyType',
            'catalog': 'catalog',
            'storage': 'storage'
        }
        self._connection_type = None
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._vault_id = None
        self._key_id = None
        self._ingress_ips = None
        self._nsg_ids = None
        self._subnet_id = None
        self._routing_method = None
        self._locks = None
        self._does_use_secret_ids = None
        self._subscription_id = None
        self._cluster_placement_group_id = None
        self._security_attributes = None
        self._technology_type = None
        self._catalog = None
        self._storage = None
        self._connection_type = 'ICEBERG'

    @property
    def technology_type(self):
        """
        **[Required]** Gets the technology_type of this IcebergConnectionSummary.
        The Iceberg technology type.


        :return: The technology_type of this IcebergConnectionSummary.
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """
        Sets the technology_type of this IcebergConnectionSummary.
        The Iceberg technology type.


        :param technology_type: The technology_type of this IcebergConnectionSummary.
        :type: str
        """
        self._technology_type = technology_type

    @property
    def catalog(self):
        """
        **[Required]** Gets the catalog of this IcebergConnectionSummary.

        :return: The catalog of this IcebergConnectionSummary.
        :rtype: oci.golden_gate.models.IcebergCatalogSummary
        """
        return self._catalog

    @catalog.setter
    def catalog(self, catalog):
        """
        Sets the catalog of this IcebergConnectionSummary.

        :param catalog: The catalog of this IcebergConnectionSummary.
        :type: oci.golden_gate.models.IcebergCatalogSummary
        """
        self._catalog = catalog

    @property
    def storage(self):
        """
        **[Required]** Gets the storage of this IcebergConnectionSummary.

        :return: The storage of this IcebergConnectionSummary.
        :rtype: oci.golden_gate.models.IcebergStorageSummary
        """
        return self._storage

    @storage.setter
    def storage(self, storage):
        """
        Sets the storage of this IcebergConnectionSummary.

        :param storage: The storage of this IcebergConnectionSummary.
        :type: oci.golden_gate.models.IcebergStorageSummary
        """
        self._storage = storage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
